#!/usr/bin/perl

use strict;
use warnings;

use Test::More tests => 4;

use CGI;
use CGIParameters qw( read_cgi_parameters );

my $cgi = CGI->new( { a => [ 1 ], b => [ 1, 2 ], c => [ 1, 2 ] } );
my( $param, $changed ) =
    read_cgi_parameters( $cgi,
                         { a => { re => '\d' },
                           b => { re => '\d' },
                           c => { re => '\d', multiple => 1 } } );

ok( $param->{a} eq '1' );
ok( $param->{b} eq '1' );
ok( $param->{c}[0] eq '1' );
ok( $param->{c}[1] eq '2' );
