#!/bin/sh
#
# This file is part of Rheolef.
#
# Copyright (C) 2000-2009 Pierre Saramito 
#
# Rheolef is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# Rheolef is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with Rheolef; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# -------------------------------------------------------------------------
if [ x"${GZIP_BIN}" = x"" ]; then
    echo "can not test since GZIP_BIN is missing" 1>&2
    exit 0
fi
TOP_SRCDIR=${TOP_SRCDIR-"../../../rheolef"}
GEODIR=${GEODIR-"../../../rheolef/nfem/data"}
BINDIR=../bin
TMPDIR=${TMPDIR-"/tmp"}

echo "checking for geometry input-output..."

geo_list="
	carre
	circle
	circle-pb
	cercle
	cube-tetra-1
        box-T-2
	bielle
	particule
	dodecaedre00
	dodecaedre01"

# prevent aborts during tests...
/bin/rm -f core; touch core; chmod a-w core

tmpgeo="$TMPDIR/geo-$$.geo"
/bin/rm -f $tmpgeo

status=0
for g in ${geo_list}; do
    echo "      ${BINDIR}/geo -check -ndigit 10 -output-as-double -geo ${GEODIR}/${g}"
    ${BINDIR}/geo -check -ndigit 10 -output-as-double -geo ${GEODIR}/${g} > $tmpgeo 2> /dev/null
    /bin/sh ${TOP_SRCDIR}/config/zdiff -bw ${GEODIR}/${g}.geo.gz $tmpgeo # >/dev/null
    if test $? -ne 0; then status=1; echo "        => *NO*"; fi
done

#
# upgrade
#
upgrade_list="carre tetra2"
for g in ${upgrade_list}; do
    echo "      ${BINDIR}/geo -check -ndigit 10 -output-as-double -upgrade -geo ${GEODIR}/${g}"
    ${BINDIR}/geo -check -upgrade -ndigit 10 -output-as-double -geo ${GEODIR}/${g} > $tmpgeo 2>/dev/null
    /bin/sh ${TOP_SRCDIR}/config/zdiff -bw ${GEODIR}/${g}-v2.geo.gz $tmpgeo >/dev/null
    if test $? -ne 0; then status=1; echo "        => *NO*"; fi
done
#
# bamg2geo conversion
#
echo "      cat ${GEODIR}/crack.bamg ${GEODIR}/crack.dmn | ${BINDIR}/geo -check -output-as-double -input-bamg -upgrade -geo -"
cat ${GEODIR}/crack.bamg ${GEODIR}/crack.dmn | \
    ${BINDIR}/geo -check -output-as-double -ndigit 5 -input-bamg -upgrade -geo - 2>/dev/null| \
    diff -bw ${GEODIR}/crack.geo - 
if test $? -ne 0; then status=1; echo "        => *NO*"; fi

/bin/rm -f $tmpgeo

exit ${status}

