/* ====================================================================
 * ===  Copyright (C) 1998-2007 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 * 
 *    Project              : sagcad
 *    Description          : CAD/CAM
 *    Source               : Assistance.h
 * 
 *    ----------------------------------
 * 
 *    License              : GNU General Public License (GPL)
 *    Copyright            : (C) 1998-2007 by Yutaka Sagiya
 *    email                : kappa@a6s.highway.ne.jp
 *                         : yutaka@sagiya.com
 *    Begin                : 2001/02/27
 *    Last                 : 2007/11/08
 * ====================================================================
 */
#ifndef __ASSISTANCE_H__
#define __ASSISTANCE_H__

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */



/* -------------------------------------------------------
 * 1 : 前処理  (struct #define etc)
 * -------------------------------------------------------
 */



/* -------------------------------------------------------
 * 2 : 外部変数 (global)
 * -------------------------------------------------------
 */
#ifdef _ASSISTANCE_
#define   GLOBAL
// 初期値設定
#define   GLOBAL_VAL(v)  = (v)
#else
#define   GLOBAL	extern
// 初期値設定の代入部分を無くす
#define   GLOBAL_VAL(v)  /* */
#endif




#undef  GLOBAL
#undef  GLOBAL_VAL
#undef _ASSISTANCE_



/* -------------------------------------------------------
 * 3 : 外部関数 (Function)
 * -------------------------------------------------------
 */
int SearchPointDraw(GtkWidget *widget, double x, double y, long color);
double ArrowLength(int DrawType);
int LineEndArrow(GtkWidget *widget, double SX, double SY, double EX, double EY, int LineFrag, int DrawType, long color);
int LineBothArrow(GtkWidget *widget, double SX, double SY, double EX, double EY, int LineFrag, int DrawType, long color);
int LineBothConverseArrow(GtkWidget *widget, double SX, double SY, double EX, double EY, int LineFrag, int DrawType, long color);
int ArcBothArrow(GtkWidget *widget, double CX, double CY, double R, double SX, double SY, double EX, double EY, int ArcFrag, int DrawType, long color);
//int ArcBothArrow(GtkWidget *widget, double CX, double CY, double R, double SA, double EA, int ArcFrag, int DrawType);
int AssistanceLine(GtkWidget *widget, double SX, double SY, double EX, double EY, int DrawType, long color);
int LineEndExtension(GtkWidget *widget, double SX, double SY, double EX, double EY, int DrawType, long color);




#ifdef __cplusplus
}
#endif /* __cplusplus */
#endif /* __ASSISTANCE_H__ */
/* ====================================================================
 * ===  Copyright (C) 1998-2007 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 *    Project              : sagcad
 *    Source               : Assistance.h
 * ====================================================================
 */
