#ifndef INCLUDED_UDSREQ_
#define INCLUDED_UDSREQ_

#include <iosfwd>
#include <vector>

struct UDSReq
{
    enum Req
    {
        ERROR,
        LIST,
        RELOAD,
        TERMINATE
    };

    private:
        using Pair = std::pair<Req, char const *>;
        using Vect = std::vector<Pair>;

        static Vect s_vect;

    public:
        static char const *name(Req req);
        static Req find(std::string const &cmd);
};

#endif




