; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -verify-machineinstrs < %s -mcpu=pwr4 -mattr=-altivec \
; RUN:     -mtriple=powerpc-ibm-aix-xcoff | \
; RUN:   FileCheck %s -check-prefix=AIX32

; RUN: llc -verify-machineinstrs < %s -mcpu=pwr4 -mattr=-altivec \
; RUN:     -mtriple=powerpc64-ibm-aix-xcoff | \
; RUN:   FileCheck %s -check-prefixes=AIX64

declare void @clobber(ptr)

define dso_local float @frameptr_only(i32 %n, float %f) {
; AIX32-LABEL: frameptr_only:
; AIX32:       # %bb.0: # %entry
; AIX32-NEXT:    mflr 0
; AIX32-NEXT:    stw 31, -12(1)
; AIX32-NEXT:    stw 0, 8(1)
; AIX32-NEXT:    stwu 1, -80(1)
; AIX32-NEXT:    slwi 3, 3, 2
; AIX32-NEXT:    mr 31, 1
; AIX32-NEXT:    stfd 31, 72(31) # 8-byte Folded Spill
; AIX32-NEXT:    fmr 31, 1
; AIX32-NEXT:    addi 3, 3, 15
; AIX32-NEXT:    addi 4, 31, 80
; AIX32-NEXT:    rlwinm 3, 3, 0, 0, 27
; AIX32-NEXT:    neg 3, 3
; AIX32-NEXT:    stwux 4, 1, 3
; AIX32-NEXT:    addi 3, 1, 64
; AIX32-NEXT:    bl .clobber[PR]
; AIX32-NEXT:    nop
; AIX32-NEXT:    fmr 1, 31
; AIX32-NEXT:    lfd 31, 72(31) # 8-byte Folded Reload
; AIX32-NEXT:    lwz 1, 0(1)
; AIX32-NEXT:    lwz 0, 8(1)
; AIX32-NEXT:    mtlr 0
; AIX32-NEXT:    lwz 31, -12(1)
; AIX32-NEXT:    blr
;
; AIX64-LABEL: frameptr_only:
; AIX64:       # %bb.0: # %entry
; AIX64-NEXT:    mflr 0
; AIX64-NEXT:    std 31, -16(1)
; AIX64-NEXT:    std 0, 16(1)
; AIX64-NEXT:    stdu 1, -144(1)
; AIX64-NEXT:    rldic 3, 3, 2, 30
; AIX64-NEXT:    mr 31, 1
; AIX64-NEXT:    stfd 31, 136(31) # 8-byte Folded Spill
; AIX64-NEXT:    fmr 31, 1
; AIX64-NEXT:    addi 3, 3, 15
; AIX64-NEXT:    addi 4, 31, 144
; AIX64-NEXT:    rldicl 3, 3, 60, 4
; AIX64-NEXT:    rldicl 3, 3, 4, 29
; AIX64-NEXT:    neg 3, 3
; AIX64-NEXT:    stdux 4, 1, 3
; AIX64-NEXT:    addi 3, 1, 112
; AIX64-NEXT:    bl .clobber[PR]
; AIX64-NEXT:    nop
; AIX64-NEXT:    fmr 1, 31
; AIX64-NEXT:    lfd 31, 136(31) # 8-byte Folded Reload
; AIX64-NEXT:    ld 1, 0(1)
; AIX64-NEXT:    ld 0, 16(1)
; AIX64-NEXT:    mtlr 0
; AIX64-NEXT:    ld 31, -16(1)
; AIX64-NEXT:    blr
entry:
  %0 = alloca i32, i32 %n
  call void @clobber(ptr %0)
  ret float %f
}

define dso_local void @frameptr_realigned(i32 %n) {
; AIX32-LABEL: frameptr_realigned:
; AIX32:       # %bb.0:
; AIX32-NEXT:    mflr 0
; AIX32-NEXT:    stw 31, -4(1)
; AIX32-NEXT:    stw 30, -8(1)
; AIX32-NEXT:    mr 30, 1
; AIX32-NEXT:    stw 0, 8(1)
; AIX32-NEXT:    clrlwi 0, 1, 26
; AIX32-NEXT:    subfic 0, 0, -192
; AIX32-NEXT:    stwux 1, 1, 0
; AIX32-NEXT:    slwi 3, 3, 2
; AIX32-NEXT:    lwz 4, 0(1)
; AIX32-NEXT:    li 5, -64
; AIX32-NEXT:    addi 3, 3, 15
; AIX32-NEXT:    mr 31, 1
; AIX32-NEXT:    rlwinm 3, 3, 0, 0, 27
; AIX32-NEXT:    neg 3, 3
; AIX32-NEXT:    and 5, 3, 5
; AIX32-NEXT:    stwux 4, 1, 5
; AIX32-NEXT:    addi 3, 1, 64
; AIX32-NEXT:    bl .clobber[PR]
; AIX32-NEXT:    nop
; AIX32-NEXT:    mr 1, 30
; AIX32-NEXT:    lwz 0, 8(1)
; AIX32-NEXT:    mtlr 0
; AIX32-NEXT:    lwz 31, -4(1)
; AIX32-NEXT:    lwz 30, -8(1)
; AIX32-NEXT:    blr
;
; AIX64-LABEL: frameptr_realigned:
; AIX64:       # %bb.0:
; AIX64-NEXT:    mflr 0
; AIX64-NEXT:    std 31, -8(1)
; AIX64-NEXT:    std 30, -16(1)
; AIX64-NEXT:    mr 30, 1
; AIX64-NEXT:    std 0, 16(1)
; AIX64-NEXT:    clrldi 0, 1, 58
; AIX64-NEXT:    subfic 0, 0, -256
; AIX64-NEXT:    stdux 1, 1, 0
; AIX64-NEXT:    rldic 3, 3, 2, 30
; AIX64-NEXT:    ld 4, 0(1)
; AIX64-NEXT:    li 5, -64
; AIX64-NEXT:    addi 3, 3, 15
; AIX64-NEXT:    mr 31, 1
; AIX64-NEXT:    rldicl 3, 3, 60, 4
; AIX64-NEXT:    rldicl 3, 3, 4, 29
; AIX64-NEXT:    neg 3, 3
; AIX64-NEXT:    and 5, 3, 5
; AIX64-NEXT:    stdux 4, 1, 5
; AIX64-NEXT:    addi 3, 1, 128
; AIX64-NEXT:    bl .clobber[PR]
; AIX64-NEXT:    nop
; AIX64-NEXT:    mr 1, 30
; AIX64-NEXT:    ld 0, 16(1)
; AIX64-NEXT:    mtlr 0
; AIX64-NEXT:    ld 31, -8(1)
; AIX64-NEXT:    ld 30, -16(1)
; AIX64-NEXT:    blr
  %ptr = alloca i32, i32 %n, align 64
  call void @clobber(ptr %ptr)
  ret void
}
