/*
 * Copyright (C) 2023, KylinSoft Co., Ltd.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 *
**/
#ifndef DATETIMEUI_H
#define DATETIMEUI_H

#include "titlelabel.h"
#include "timeBtn.h"
#include "timelabel.h"
#include "clockwidget.h"
#include "calendarwidget.h"
#include "dategroupwidget.h"
#include "dateedit.h"
#include "fixlabel.h"
#include "settinggroup.h"
#include "ukccframe.h"
#include "fixbutton.h"
#include "addbutton.h"
#include "comboxwidget.h"
#include <QWidget>
#include <QVBoxLayout>
#include <QLineEdit>
#include <QRadioButton>
#include <QButtonGroup>

class DatetimeUi : public QWidget
{
    Q_OBJECT
public:
    DatetimeUi();
    ~DatetimeUi();
    void setTimeMode(QString mode);
    void setSyncResultLabel(int flag);
    void setNtpServers(QStringList sl);
    void setNtpServer(QString s);
    void setTimezoneStr(QString str);
    void addOtherTimezone(const QString &timezone, const QString & timezoneName);
    void setAddTimezoneBtnEnabled(bool b);
    void resetDateFormat();
    void updateDate();

// 初始化
private:
    void initUi();
    void initObject();
    void initCurrentDate();
    void initOtherTimezone();
    void initSignals();

private slots:
    void updateDateFormat(QString date);

private:
    QVBoxLayout *uiLayout            = nullptr;
    QVBoxLayout *currentDateLayout   = nullptr;
    QVBoxLayout *otherTimezoneLayout = nullptr;

private:
    // 当前时间
    TitleLabel      *currentTitleLabel = nullptr;
    ClockWidget     *clockWidget       = nullptr;
    TimeLabel       *timeLabel         = nullptr;
    FixLabel        *mDateLabel        = nullptr;
    FixButton       *changeTZbutton    = nullptr;
    FixLabel        *setTimeModeLabel  = nullptr;
    QRadioButton    *manualRadioButton = nullptr;
    QRadioButton    *syncRadioButton   = nullptr;
    FixLabel        *syncResultLabel   = nullptr;
    FixLabel        *setDateLabel      = nullptr;
    DategroupWidget *dategroupWidget   = nullptr;
    ComboxWidget    *ntpSerWidget      = nullptr;
    FixLabel        *setNtpLabel       = nullptr;
    QLineEdit       *setNtpLineEdit    = nullptr;
    FixButton       *setNtpButton      = nullptr;
    // 其他时区时间
    TitleLabel *otherTimezoneTitleLabel = nullptr;
    AddButton  *addTimezoneButton       = nullptr;

private:
    QString      timezoneStr   = "";
    QButtonGroup *timeBtnGroup = nullptr;
    int          toggledBtn = -1;

Q_SIGNALS:
     // 时间日期改变
    void dateTimeChanged(QDate date, QTime time);
    // 时间模式改变
    void timeModeChanged(int id, QString mode);
    // 修改时区按钮点击
    void timezoneButtonClicked();
    // NTP服务器修改
    void ntpServerChanged(QString server);
    // 添加时区按钮点击
    void addTimezoneButtonClicked();
    // 时区移除
    void timezoneRemoved(QString zone);
};

#endif // DATETIMEUI_H
