/*
 * Decompiled with CFR 0.152.
 */
package writer2latex.util;

import java.util.Enumeration;
import java.util.Hashtable;
import writer2latex.util.Misc;
import writer2latex.util.SimpleInputBuffer;

public class ExportNameCollection {
    private Hashtable<String, String> exportNames = new Hashtable();
    private String sPrefix;
    private String sAdditionalChars;
    private boolean bAcceptNumbers;

    public ExportNameCollection(String sPrefix, boolean bAcceptNumbers, String sAdditionalChars) {
        this.sPrefix = sPrefix;
        this.bAcceptNumbers = bAcceptNumbers;
        this.sAdditionalChars = sAdditionalChars;
    }

    public ExportNameCollection(String sPrefix, boolean bAcceptNumbers) {
        this(sPrefix, bAcceptNumbers, "");
    }

    public ExportNameCollection(boolean bAcceptNumbers) {
        this("", bAcceptNumbers, "");
    }

    public Enumeration<String> keys() {
        return this.exportNames.keys();
    }

    public void addName(String sName) {
        char c;
        if (this.containsName(sName)) {
            return;
        }
        StringBuilder outbuf = new StringBuilder();
        SimpleInputBuffer inbuf = new SimpleInputBuffer(sName);
        if (this.bAcceptNumbers && inbuf.peekChar() >= '0' && inbuf.peekChar() <= '9') {
            outbuf.append('a');
        }
        while ((c = inbuf.peekChar()) != '\u0000') {
            if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z') {
                outbuf.append(inbuf.getChar());
                continue;
            }
            if (c >= '0' && c <= '9') {
                if (this.bAcceptNumbers) {
                    outbuf.append(inbuf.getInteger());
                    continue;
                }
                outbuf.append(Misc.int2roman(Integer.parseInt(inbuf.getInteger())));
                continue;
            }
            if (this.sAdditionalChars.indexOf(c) > -1) {
                outbuf.append(inbuf.getChar());
                continue;
            }
            inbuf.getChar();
        }
        String sExportName = outbuf.toString();
        if (sExportName.length() == 0) {
            sExportName = "qwerty";
        }
        if (!this.exportNames.containsValue(sExportName)) {
            this.exportNames.put(sName, sExportName);
        } else {
            String sSuffix;
            int i = 1;
            do {
                sSuffix = Misc.int2alph(i++, false);
            } while (this.exportNames.containsValue(sExportName + sSuffix));
            this.exportNames.put(sName, sExportName + sSuffix);
        }
    }

    public String getExportName(String sName) {
        if (!this.containsName(sName)) {
            this.addName(sName);
        }
        return this.sPrefix + this.exportNames.get(sName);
    }

    public boolean containsName(String sName) {
        return this.exportNames.containsKey(sName);
    }

    public boolean isEmpty() {
        return this.exportNames.size() == 0;
    }
}

