# 0.1.0

**Version:** 0.1.0
**Published:** 2025-05-24T22:00:55Z

## Release Notes

### 📦 **Rust Coreutils 0.1.0 Release:**

We are excited to announce the release of **Rust Coreutils 0.1.0** — our first 0.1 milestone!
This release brings **major performance gains**, **SELinux support**, and expanded **GNU compatibility**.

---

### Highlights:

- **SELinux Support**
  New SELinux integration in `cp`, `ls`, `mkdir`, `mknod`, `mkfifo`, `install`, and `stat`.
  Plus, SELinux-aware CI testing is now live!

- **Performance Improvements**
  Notable speedups in `cat`, `ls`, `wc`, `tail`, `seq`, and more — many now **match or exceed GNU performance**.

- **Ubuntu Plans to Ship uutils**
  Ubuntu is beginning to integrate Rust Coreutils into its base system!
  ➤ [Oxidizing Ubuntu](https://discourse.ubuntu.com/t/carefully-but-purposefully-oxidising-ubuntu/56995)

- **Huge Contribution Wave**
  This release includes **843 commits** from **60+ contributors**, including **40 newcomers**!

---

### GNU Test Suite Compatibility:

| Result        | 0.0.30 | 0.1.0 | Change 0.0.30 to 0.1.0 | % Total 0.0.30 | % Total 0.1.0 | % Change 0.0.30 to 0.1.0 |
|---------------|--------|--------|------------------------|----------------|---------------|--------------------------|
| Pass          | 507    | 522    | +15                    | 82.17%         | 84.46%        | +2.29%                   |
| Skip          | 41     | 31     | -10                    | 6.65%          | 5.02%         | -1.63%                   |
| Fail          | 69     | 65     | -4                     | 11.18%         | 10.52%        | -0.66%                   |
| Total         | 617    | 618    | +1 (new test)          |                |               |                          |

---

![GNU testsuite evolution](https://github.com/uutils/coreutils-tracking/blob/main/gnu-results.svg?raw=true)

---

### Call to Action:

🚀 **Sponsor us on GitHub** to help us grow faster: [github.com/sponsors/uutils](https://github.com/sponsors/uutils)
🔗 Download the latest release & learn more: [https://uutils.github.io](https://uutils.github.io)

## What's Changed

## basenc
* base32/base64/basenc: add -D flag by @TerakomariGandesblood in https://github.com/uutils/coreutils/pull/7479

## cat
* cat: Improve performance of formatting. by @karlmcdowall in https://github.com/uutils/coreutils/pull/7519
* cat: bugfix when running with -T option by @karlmcdowall in https://github.com/uutils/coreutils/pull/7636
* cat: Formatting performance improvement by @karlmcdowall in https://github.com/uutils/coreutils/pull/7642
* cat: Performance improvement when printing line numbers by @karlmcdowall in https://github.com/uutils/coreutils/pull/7645

## chmod
* chmod: Correct chmod -R on dangling symlink and tests by @CSRessel in https://github.com/uutils/coreutils/pull/7618

## chroot
* Fix chroot trying to change into non-existent directory by @jplatte in https://github.com/uutils/coreutils/pull/7803

## cksum
* cksum: take out regex pattern matching by @GTimothy in https://github.com/uutils/coreutils/pull/7580

## cp
* cp: Use FICLONE ioctl constant from linux-raw-sys by @dezgeg in https://github.com/uutils/coreutils/pull/7439
* cp: fix update prompting by @hz2 in https://github.com/uutils/coreutils/pull/7668
* cp -P hardlink-to-symlink hardlink-to-same-symlink should no-op by @dan-hipschman in https://github.com/uutils/coreutils/pull/7753
* cp: refuse to copy symlink over itself by @dan-hipschman in https://github.com/uutils/coreutils/pull/7729
* cp: use `authors.workspace` in `Cargo.toml` by @cakebaker in https://github.com/uutils/coreutils/pull/7882
* cp: improve the selinux support by @sylvestre in https://github.com/uutils/coreutils/pull/7878
* cp: context Disable a check in tests/cp/no-ctx.sh by @sylvestre in https://github.com/uutils/coreutils/pull/7938
* cp: copy dir if source path ends with dot by @cakebaker in https://github.com/uutils/coreutils/pull/7874

## csplit
* csplit: removed unnecesary implementation of From<io::Error> by @lukasx999 in https://github.com/uutils/coreutils/pull/7778
* csplit: don't add a newline if the file doesn't end with one by @Qelxiros in https://github.com/uutils/coreutils/pull/7901

## date
* date: allow negative date offsets by @lewisboon in https://github.com/uutils/coreutils/pull/7548
* date: add tests for relative weekdays by @dan-hipschman in https://github.com/uutils/coreutils/pull/7843
* date: move file header to top & merge some imports by @cakebaker in https://github.com/uutils/coreutils/pull/7857
* refactor(tests): use absolute difference of dates to check if they are within a window by @lavafroth in https://github.com/uutils/coreutils/pull/7755

## dd
* feat: optimize `dd` parsing, bugfix by @nyurik in https://github.com/uutils/coreutils/pull/7704

## df
* refactor: Add thiserror to df by @kiran-4444 in https://github.com/uutils/coreutils/pull/7545
* df: migrate OptionsError to thiserror by @lewisboon in https://github.com/uutils/coreutils/pull/7673
* fix: df: filter filesystem types after mount point resolution by @SergeiPatiakin in https://github.com/uutils/coreutils/pull/7452

## du
* du: don't panic on block-size 0 by @BenWiederhake in https://github.com/uutils/coreutils/pull/7742
* du: fix "function never used" warning in test by @cakebaker in https://github.com/uutils/coreutils/pull/7943

## echo
* echo: fixed double hyphen as argument by @cerdelen in https://github.com/uutils/coreutils/pull/7581
* Remove clap for echo by @cerdelen in https://github.com/uutils/coreutils/pull/7603

## env
* env: ignore flags after the command or -- argument by @dan-hipschman in https://github.com/uutils/coreutils/pull/7781
* docs: env doesn't handle the empty string as a variable name by @Qelxiros in https://github.com/uutils/coreutils/pull/7956

## expr
* expr: Refactor AST evaluation to avoid stack overflow by @LouisDISPA in https://github.com/uutils/coreutils/pull/7388
* expr: Escape anchor characters within pattern by @frendsick in https://github.com/uutils/coreutils/pull/7842
* expr: Fix regex anchor matching behavior with `REGEX_OPTION_SINGLELINE` by @frendsick in https://github.com/uutils/coreutils/pull/7846
* expr: Fix parsing negated character classes "[^a]" by @frendsick in https://github.com/uutils/coreutils/pull/7884
* expr: Fix parsing regex anchors '^' and '$' by @frendsick in https://github.com/uutils/coreutils/pull/7953

## false
* true,false: remove unnecessary newline from version string by @cakebaker in https://github.com/uutils/coreutils/pull/7446

## fmt
* chore: minor fmt match cleanup by @nyurik in https://github.com/uutils/coreutils/pull/7722
* Run cargo fmt on missed files by @BenWiederhake in https://github.com/uutils/coreutils/pull/7949
* ci: run `cargo fmt --check` in `fuzz` folder by @cakebaker in https://github.com/uutils/coreutils/pull/7958

## head
* head: rework handling of non-seekable files by @karlmcdowall in https://github.com/uutils/coreutils/pull/7438
* head: fix overflow errors by @Qelxiros in https://github.com/uutils/coreutils/pull/7721

## hostid
* hostid: use `gethostid` from Rust `libc` by @cakebaker in https://github.com/uutils/coreutils/pull/7571

## hostname
* Bump `hostname` & remove `windows-core` from skip list by @cakebaker in https://github.com/uutils/coreutils/pull/7713

## id
* bug: fix id printing of egid by @nyurik in https://github.com/uutils/coreutils/pull/7696
* id: Handle NULL pointer gracefully within `cstr2cow` macro by @frendsick in https://github.com/uutils/coreutils/pull/7810
* id: adapt error message to match the one from GNU `id` by @cakebaker in https://github.com/uutils/coreutils/pull/7836
* id: The `--real` flag should only affect `-u`, `-g`, and `-G` by @frendsick in https://github.com/uutils/coreutils/pull/7796
* id: remove unnecessary `to_string` calls by @cakebaker in https://github.com/uutils/coreutils/pull/7914

## install
* install: friendly message install file to directory by @zhw2101024 in https://github.com/uutils/coreutils/pull/7794
* install: fixes issue #7795 by @zcg00 in https://github.com/uutils/coreutils/pull/7838
* Install implement the --no-target-directory option by @zhw2101024 in https://github.com/uutils/coreutils/pull/7867
* install: remove todos by @cakebaker in https://github.com/uutils/coreutils/pull/7872
* ci: install `libselinux1-dev` for coverage job by @cakebaker in https://github.com/uutils/coreutils/pull/7959
* selinux: start the support of install by @sylvestre in https://github.com/uutils/coreutils/pull/7908

## ls
* ls: More performance optimizations by @drinkcat in https://github.com/uutils/coreutils/pull/7813
* ls: add -T support and fix --classify output by @emar-kar in https://github.com/uutils/coreutils/pull/7616
* ls: add selinux support by @sylvestre in https://github.com/uutils/coreutils/pull/7768
* ls: Print optimizations by @drinkcat in https://github.com/uutils/coreutils/pull/7801
* ls: update chrono crate version and switch to `new_lenient` use by @emar-kar in https://github.com/uutils/coreutils/pull/7858
* ls: remove duplicate code by @cakebaker in https://github.com/uutils/coreutils/pull/7932
* test_ls: Improve test_ls_perm_io_errors by @drinkcat in https://github.com/uutils/coreutils/pull/7811

## mkdir
* mkdir: add the selinux support by @sylvestre in https://github.com/uutils/coreutils/pull/7635

## mkfifo
* mkfifo: implement selinux support by @sylvestre in https://github.com/uutils/coreutils/pull/7831

## mknod
* mknod: remove windows-related code & flags by @cakebaker in https://github.com/uutils/coreutils/pull/7821
* mknod: implement selinux support by @sylvestre in https://github.com/uutils/coreutils/pull/7818
* mknod: rename function `_mknod` to `mknod` by @cakebaker in https://github.com/uutils/coreutils/pull/7824
* mknod: refactor `uumain` by @cakebaker in https://github.com/uutils/coreutils/pull/7825
* mknod: remove duplicate test by @cakebaker in https://github.com/uutils/coreutils/pull/7828

## mktemp
* mktemp: Prevent race condition when setting permissions for tempdir by @MidnightRocket in https://github.com/uutils/coreutils/pull/7617

## more
* more: keep only screen lines in mem by @aaron-ang in https://github.com/uutils/coreutils/pull/7680
* more: constant memory initialization overhead by @aaron-ang in https://github.com/uutils/coreutils/pull/7765

## mv
* Implement `Default` for `Options` of `mv` and `cp` by @jmjoy in https://github.com/uutils/coreutils/pull/7506
* mv: fix moving FIFO to a different filesystem by @jfinkels in https://github.com/uutils/coreutils/pull/7241
* mv: use `bool` instead of `Result` as return type by @cakebaker in https://github.com/uutils/coreutils/pull/7962
* mv: factor rename_with_fallback function into helpers by @jfinkels in https://github.com/uutils/coreutils/pull/7774

## numfmt
* numfmt: add --zero-terminated option by @dan-hipschman in https://github.com/uutils/coreutils/pull/7686

## od
* od: fix for issue #7666 by @karlmcdowall in https://github.com/uutils/coreutils/pull/7776

## pr
* pr: migrate from quick-error to thiserror by @Qelxiros in https://github.com/uutils/coreutils/pull/7919

## printf
* printf: fix octal escape parsing by @RenjiSann in https://github.com/uutils/coreutils/pull/7431
* printf: trim leading whitespace when parsing numeric values by @dlrobertson in https://github.com/uutils/coreutils/pull/7512
* printf: Consistently handle negative widths/precision by @sargas in https://github.com/uutils/coreutils/pull/7620
* printf: make negative values wrap around with unsigned/hex format by @eduardorittner in https://github.com/uutils/coreutils/pull/7656
* printf: Error handling with unicode parsing by @sargas in https://github.com/uutils/coreutils/pull/7681
* fuzzing: add a summary and enable printf by @sylvestre in https://github.com/uutils/coreutils/pull/7747
* printf: improve support of printing multi-byte values of characters by @jtracey in https://github.com/uutils/coreutils/pull/7208
* printf: Add indexing to format strings by @sargas in https://github.com/uutils/coreutils/pull/7837
* printf: use non-zero indexes by @jtracey in https://github.com/uutils/coreutils/pull/7855
* Fix `nan` print, simplify negative number printing. by @drinkcat in https://github.com/uutils/coreutils/pull/7413
* parser: Fix 3 corner cases by @drinkcat in https://github.com/uutils/coreutils/pull/7694

## ptx
* ptx: fixes by @usamoi in https://github.com/uutils/coreutils/pull/7521
* ptx: use char count instead of byte index to handle utf-8 characters by @aaron-ang in https://github.com/uutils/coreutils/pull/7897

## rm
* rm: skip prompt when stdin is not interactive; Fix #7326 by @bitspill in https://github.com/uutils/coreutils/pull/7492

## seq
* seq: fix default float precision (`%f`); fix 0 scientific printing by @drinkcat in https://github.com/uutils/coreutils/pull/7384
* seq: Buffer writes to stdout by @drinkcat in https://github.com/uutils/coreutils/pull/7485
* seq: Directly write separator string, instead of using format by @drinkcat in https://github.com/uutils/coreutils/pull/7562
* seq: Do not allow -w and -f to be specified at the same time by @drinkcat in https://github.com/uutils/coreutils/pull/7646
* seq: Trim whitespaces, then try to remove + by @drinkcat in https://github.com/uutils/coreutils/pull/7650
* test_seq: Add a few more tests for corner cases by @drinkcat in https://github.com/uutils/coreutils/pull/7527

## shred
* shred: remove unwanted padding in verbose messages by @BenWiederhake in https://github.com/uutils/coreutils/pull/7799
* shred: correctly print zero-byte pass in verbose mode by @BenWiederhake in https://github.com/uutils/coreutils/pull/7800
* shred: fix random passes* by @Qelxiros in https://github.com/uutils/coreutils/pull/7830
* shred: remove obsolete test by @cakebaker in https://github.com/uutils/coreutils/pull/7833
* shred: document simplified (better?) number of random passes by @BenWiederhake in https://github.com/uutils/coreutils/pull/7847
* shred: add 4K data alignment by @alexs-sh in https://github.com/uutils/coreutils/pull/7915
* shred: minor improvements and tests by @alexs-sh in https://github.com/uutils/coreutils/pull/7925

## shuf
* Make `shuf` OsStr-compliant and bring newline handling in line with GNU by @blyxxyz in https://github.com/uutils/coreutils/pull/7463

## sleep
* sleep: remove unused `fundu` from `Cargo.toml` by @cakebaker in https://github.com/uutils/coreutils/pull/7758
* util/build-gnu.sh: Accept hex float as sleep parameter by @drinkcat in https://github.com/uutils/coreutils/pull/7761

## sort
* sort: immediately compare whole lines if they parse as numbers by @MoSal in https://github.com/uutils/coreutils/pull/7567

## split
* split: fix a racing condition that causes issue #7869 by @yuankunzhang in https://github.com/uutils/coreutils/pull/7877
* split: use delegation to avoid code duplication in test by @cakebaker in https://github.com/uutils/coreutils/pull/7924

## stat
* stat: Print what kind of "weird" mode it is, if it's "weird" by @drinkcat in https://github.com/uutils/coreutils/pull/7587
* stat: add support for selinux  by @sylvestre in https://github.com/uutils/coreutils/pull/7752
* test_stat: Disable test_stdin_pipe_fifo1/2 on Mac OS X by @drinkcat in https://github.com/uutils/coreutils/pull/7611

## sum
* sum: Rework some error handling by @karlmcdowall in https://github.com/uutils/coreutils/pull/7605

## sync
* sync: move call to unsafe fn to unsafe block by @cakebaker in https://github.com/uutils/coreutils/pull/7942

## tail
* tail: Performance improvements by @karlmcdowall in https://github.com/uutils/coreutils/pull/7643
* tail: Ignore a few tests on selinux by @sylvestre in https://github.com/uutils/coreutils/pull/7756
* tail: fix issue with -v flag and stdin by @karlmcdowall in https://github.com/uutils/coreutils/pull/7792
* tail hex parsing, remove fundu dependency by @Qelxiros in https://github.com/uutils/coreutils/pull/7760
* Tail macos stdin ran from script fix by @hz2 in https://github.com/uutils/coreutils/pull/7844

## tee
* add tests/misc/tee.sh to the list of intermittent issues by @sylvestre in https://github.com/uutils/coreutils/pull/7820

## test
* CI: add a new job to test with Selinux by @sylvestre in https://github.com/uutils/coreutils/pull/7440
* cp: create failing test for #7455 by @Carreau in https://github.com/uutils/coreutils/pull/7457
* selinux: run the GNU test too by @sylvestre in https://github.com/uutils/coreutils/pull/7448
* Add test to ensure arch output is not empty by @valerioedu in https://github.com/uutils/coreutils/pull/7523
* ci: Enable cspell on test on dotfiles too by @drinkcat in https://github.com/uutils/coreutils/pull/7582
* Test workspace CI on macos by @drinkcat in https://github.com/uutils/coreutils/pull/7576
* env: Removed parse_errors to follow other commands standard with "thiserror" + added errors test case by @ValentinBoudevin in https://github.com/uutils/coreutils/pull/7584
* Bump `bigdecimal` & fix failing test by @cakebaker in https://github.com/uutils/coreutils/pull/7630
* test/cp: Fix "No such file or directory" error in test_acl_preserve by @shskwmt in https://github.com/uutils/coreutils/pull/7677
* du: already passes GNU test in spirit, adjust test by @BenWiederhake in https://github.com/uutils/coreutils/pull/7754
* Bump `bincode` & adapt test code to API changes by @cakebaker in https://github.com/uutils/coreutils/pull/7767
* du: test existing correct behavior: warn about --inodes -b conflict by @BenWiederhake in https://github.com/uutils/coreutils/pull/7764
* test_ls: Improve acl test by @drinkcat in https://github.com/uutils/coreutils/pull/7816
* date: add `%q` test, support `%#z` properly by @drinkcat in https://github.com/uutils/coreutils/pull/7854
* test_test: Simplify test_file_N by @drinkcat in https://github.com/uutils/coreutils/pull/7579

## timeout
* timeout: Use common parser to parse time duration by @drinkcat in https://github.com/uutils/coreutils/pull/7648
* add tests against '0 in sleep/timeout durations by @Qelxiros in https://github.com/uutils/coreutils/pull/7777
* timeout: add hex parsing test by @Qelxiros in https://github.com/uutils/coreutils/pull/7940

## touch
* Fix touch -t with 2 digit years when YY > 68 by @Carreau in https://github.com/uutils/coreutils/pull/7378

## tsort
* tsort: remove duplicate sorting step by @anastygnome in https://github.com/uutils/coreutils/pull/7965

## uptime
* fix uptime on windows by @Bluemangoo in https://github.com/uutils/coreutils/pull/7430
* uptime: fix "unused import" warning in test by @cakebaker in https://github.com/uutils/coreutils/pull/7629
* uptime: fix "unused import" warnings with `musl` by @cakebaker in https://github.com/uutils/coreutils/pull/7866
* uptime: fix typo (formated -> formatted) by @cakebaker in https://github.com/uutils/coreutils/pull/7887
* uptime: some small refactorings by @cakebaker in https://github.com/uutils/coreutils/pull/7891
* uptime: fix typo (Gnu -> GNU) by @fran-tor in https://github.com/uutils/coreutils/pull/7896
* uptime: refactor `uumain` by @cakebaker in https://github.com/uutils/coreutils/pull/7892

## uucore
* Move ExtendedBigDecimal to uucore/format, make use of it in formatting functions by @drinkcat in https://github.com/uutils/coreutils/pull/7458
* uucore: format: num_format: add `fmt` function tests, and workaround 0e10 printing. by @drinkcat in https://github.com/uutils/coreutils/pull/7514
* uucore: format: num_parser: Use ExtendedBigDecimal by @drinkcat in https://github.com/uutils/coreutils/pull/7556
* uucore: format: Collection of small parser fixes by @drinkcat in https://github.com/uutils/coreutils/pull/7623
* seq: Move to uucore/format common number parsing code by @drinkcat in https://github.com/uutils/coreutils/pull/7624
* uucore: Move extendedbigdecimal and parsers to 2 separate features by @drinkcat in https://github.com/uutils/coreutils/pull/7647
* uucore: Minor fix to optional dependences by @RenjiSann in https://github.com/uutils/coreutils/pull/7654
* uucore: format: Fix hexadecimal default format print by @drinkcat in https://github.com/uutils/coreutils/pull/7631
* uucore: num_parser: Limit precision when computing 2**exp by @drinkcat in https://github.com/uutils/coreutils/pull/7712
* uucore: add `chrono` to `uptime` feature by @cakebaker in https://github.com/uutils/coreutils/pull/7719
* uucore/quoting_style: Add support for quoting/escaping empty strings by @sargas in https://github.com/uutils/coreutils/pull/7693
* fix(sleep): use uucore's from_str to support parsing hex by @Qelxiros in https://github.com/uutils/coreutils/pull/7675
* cp: factor make_fifo() function out to uucore::fs by @jfinkels in https://github.com/uutils/coreutils/pull/7775
* uucore: num_parser: Operate on slices, instead of iterator by @drinkcat in https://github.com/uutils/coreutils/pull/7790
* Move seq's `fast_inc` to `uucore`, use it in `cat` by @drinkcat in https://github.com/uutils/coreutils/pull/7782
* Allow compiling `uucore` with `wasm32-unknown-unknown` by @cptpiepmatz in https://github.com/uutils/coreutils/pull/7840
* uucore: add safe wrapper for getpgrp() by @eduardorittner in https://github.com/uutils/coreutils/pull/7676
* uucore/echo:handle ControlFlow result by @alexs-sh in https://github.com/uutils/coreutils/pull/7881
* selinux: use the uucore::selinux::is_selinux_enabled() function by @sylvestre in https://github.com/uutils/coreutils/pull/7909
* uucore: add functions to manage translations by @sylvestre in https://github.com/uutils/coreutils/pull/7955

## wc
* wc: Perf gains with the bytecount crate. by @karlmcdowall in https://github.com/uutils/coreutils/pull/7495
* wc: Speed optimization by @drinkcat in https://github.com/uutils/coreutils/pull/7934

## whoami
* whoami: remove unused libc dependency by @siddharthteli12 in https://github.com/uutils/coreutils/pull/7786

## yes
* yes: Remove usage of vmsplice by @karlmcdowall in https://github.com/uutils/coreutils/pull/7770

## Selinux
* selinux: get closer to the GNU error msgs by @sylvestre in https://github.com/uutils/coreutils/pull/7898
* selinux: rename `check_selinux_enabled()` by @cakebaker in https://github.com/uutils/coreutils/pull/7771
* set_selinux_security_context should return an Error, not String by @sylvestre in https://github.com/uutils/coreutils/pull/7845
* Cargo.toml: remove exact version requirements for `selinux` by @cakebaker in https://github.com/uutils/coreutils/pull/7883

## Code quality
* all: add `(uutils coreutils)` to version string by @cakebaker in https://github.com/uutils/coreutils/pull/7441
* Cargo.toml: use `authors.workspace = true` by @cakebaker in https://github.com/uutils/coreutils/pull/7723
* utmpx.rs: use correct constant names for musl libc by @Ecordonnier in https://github.com/uutils/coreutils/pull/7459
* fsext.rs: use type inference fsid_t / __fsid_t by @Ecordonnier in https://github.com/uutils/coreutils/pull/7469
* .pre-commit-config.yaml: Also run cspell by @drinkcat in https://github.com/uutils/coreutils/pull/7577
* Move our tests infra into a dedicated crate by @sylvestre in https://github.com/uutils/coreutils/pull/7598
* Flush `BufWriter`s, clean up error reporting by @blyxxyz in https://github.com/uutils/coreutils/pull/7622
* Consolidate crate config in workspace by @nyurik in https://github.com/uutils/coreutils/pull/7710
* chore: clean up a few code paths by @nyurik in https://github.com/uutils/coreutils/pull/7725
* enable feature_require_crate_cpp for musl by @Ecordonnier in https://github.com/uutils/coreutils/pull/7741
* enable utmpx feature for musl by @Ecordonnier in https://github.com/uutils/coreutils/pull/7740
* update parse_datetime to 0.9.0 by @sylvestre in https://github.com/uutils/coreutils/pull/7839
* Cargo.toml: Add profiling profile by @drinkcat in https://github.com/uutils/coreutils/pull/7862
* Switched to SVG graphs by @tdulcet in https://github.com/uutils/coreutils/pull/7888
* Move more programs to thiserror by @sylvestre in https://github.com/uutils/coreutils/pull/7525
* Move more errors to thiserror by @sgvictorino in https://github.com/uutils/coreutils/pull/7540
* chore: cleanup trailing commas before parens by @nyurik in https://github.com/uutils/coreutils/pull/7691
* chore: use inline formatting by @nyurik in https://github.com/uutils/coreutils/pull/7688
* chore: manual inline formatting - tests by @nyurik in https://github.com/uutils/coreutils/pull/7690
* clippy: fix warnings from Rust 1.86 by @cakebaker in https://github.com/uutils/coreutils/pull/7640
* chore: use `assert_eq!` and `assert_ne!` instead of `assert!` by @nyurik in https://github.com/uutils/coreutils/pull/7698
* feat: minor linting by @nyurik in https://github.com/uutils/coreutils/pull/7703
* Address new clippy lints by @nyurik in https://github.com/uutils/coreutils/pull/7707
* Consolidate lint management with workspaces by @nyurik in https://github.com/uutils/coreutils/pull/7709
* chore: remove unneeded parens by @nyurik in https://github.com/uutils/coreutils/pull/7700
* Fuzzing: minor fixes by @drinkcat in https://github.com/uutils/coreutils/pull/7717
* chore: manual inline formatting by @nyurik in https://github.com/uutils/coreutils/pull/7689
* chore: simplify `return` in multi-branch by @nyurik in https://github.com/uutils/coreutils/pull/7699
* chore: fix `clippy::unnested_or_patterns` by @nyurik in https://github.com/uutils/coreutils/pull/7730
* chore: fix `ref_option` lint by @nyurik in https://github.com/uutils/coreutils/pull/7724
* chore: remove trailing commas by @nyurik in https://github.com/uutils/coreutils/pull/7746
* Fix the implementation of Display and TryFrom<&str> for Teletype by @evilpie in https://github.com/uutils/coreutils/pull/7743
* Apply suggestions from clippy 0.1.87+nightly by @BenWiederhake in https://github.com/uutils/coreutils/pull/7744
* Enable and fix `unused_qualifications` lint by @nyurik in https://github.com/uutils/coreutils/pull/7715
* fix low-count lints in all crates by @nyurik in https://github.com/uutils/coreutils/pull/7716
* chore: address a few clippy lints that break API by @nyurik in https://github.com/uutils/coreutils/pull/7697
* feat: optimize iter matching by @nyurik in https://github.com/uutils/coreutils/pull/7702

## CI
* bump to Rust edition 2024 & min = 1.85 by @sylvestre in https://github.com/uutils/coreutils/pull/7423
* CI: improve the intermittent ignore by @sylvestre in https://github.com/uutils/coreutils/pull/7411
* Python: add ruff check and fix the code by @sylvestre in https://github.com/uutils/coreutils/pull/7486
* python: fix formatting in `compare_test_results.py` by @cakebaker in https://github.com/uutils/coreutils/pull/7493
* flake: drop flake-utils, refactor by @bloxx12 in https://github.com/uutils/coreutils/pull/7368
* GNU CI: fix the intermittement management by @sylvestre in https://github.com/uutils/coreutils/pull/7517
* remaining-gnu-error.py: Adjust to the new URL by @sylvestre in https://github.com/uutils/coreutils/pull/7634
* github/action: on fork, run the CI for all the branches (currently: only main) by @sylvestre in https://github.com/uutils/coreutils/pull/7604
* .github/workflows: Take care of both ./Cargo.lock and fuzz/Cargo.lock by @drinkcat in https://github.com/uutils/coreutils/pull/7653
* Fix coverage files generation by @RenjiSann in https://github.com/uutils/coreutils/pull/7401
* bump busybox & toybox reference code by @sylvestre in https://github.com/uutils/coreutils/pull/7470
* tests: replace `run()` with `succeeds()` or `fails()` by @cakebaker in https://github.com/uutils/coreutils/pull/7426
* github: fix the name - it is reference/aggregated-result.json/aggregated-result.json otherwise by @sylvestre in https://github.com/uutils/coreutils/pull/7477
* why-skip: Improve the display by @sylvestre in https://github.com/uutils/coreutils/pull/7437
* GNU/CI: use the aggregated-result.json files and move to python by @sylvestre in https://github.com/uutils/coreutils/pull/7471
* Fix Android CI by @drinkcat in https://github.com/uutils/coreutils/pull/7546
* ci: if FAIL => PASS but in the intermittent list, show the info by @sylvestre in https://github.com/uutils/coreutils/pull/7524
* flake.nix: bump minimal rust version by @sylvestre in https://github.com/uutils/coreutils/pull/7568
* deny.toml: remove two crates from skip list by @cakebaker in https://github.com/uutils/coreutils/pull/7575
* Move clippy lints from CI to `Cargo.toml` by @cakebaker in https://github.com/uutils/coreutils/pull/7748
* ci: lint with selinux by @cakebaker in https://github.com/uutils/coreutils/pull/7779
* ci: fix `unexpected input 'file'` warning in coverage job by @cakebaker in https://github.com/uutils/coreutils/pull/7960
* gnu: fix the build with selinux by @sylvestre in https://github.com/uutils/coreutils/pull/7899
* .cargo/config.toml: set `CFLAGS='-std=gnu17'` by @cakebaker in https://github.com/uutils/coreutils/pull/7944
* Revert #7944 by @cakebaker in https://github.com/uutils/coreutils/pull/7963
* upgrade to GNU coreutils 9.7 as ref by @sylvestre in https://github.com/uutils/coreutils/pull/7711
* CICD: Disable windows-latest/x86_64-pc-windows-gnu for now by @drinkcat in https://github.com/uutils/coreutils/pull/7859
* clippy: set MSRV and fix warnings by @cakebaker in https://github.com/uutils/coreutils/pull/7957
* Create an uufuzz crate for common functions and use it by @sylvestre in https://github.com/uutils/coreutils/pull/7954
* prepare release 0.1.0 by @sylvestre in https://github.com/uutils/coreutils/pull/7982

## Documentation
* CONTRIBUTING: fix broken link to Apple's file_cmds by @ohno418 in https://github.com/uutils/coreutils/pull/7460
* fixed link to repo on uutests docs by @hz2 in https://github.com/uutils/coreutils/pull/7848
* README.md: Refer to macOS when talking about the OS, not Mac (hardware) by @C0rn3j in https://github.com/uutils/coreutils/pull/7462
* uutests: add a doc by @sylvestre in https://github.com/uutils/coreutils/pull/7607
* uudoc: Fix for edition 2024 by @drinkcat in https://github.com/uutils/coreutils/pull/7573
* ci: Enable uudoc feature on x86-64 native builder by @drinkcat in https://github.com/uutils/coreutils/pull/7574
* Document the release process by @sylvestre in https://github.com/uutils/coreutils/pull/7419
* add fedora and RHEL installation docs by @benyaminl in https://github.com/uutils/coreutils/pull/7453
* docs: fix url of file with coverage results by @cakebaker in https://github.com/uutils/coreutils/pull/7528
* document how to do good performance work by @sylvestre in https://github.com/uutils/coreutils/pull/7541
* doc: bump version of ubuntu badge by @lbellomo in https://github.com/uutils/coreutils/pull/7553
* docs: replace AUR package in installation.md by @cakebaker in https://github.com/uutils/coreutils/pull/7554
* doc: fix broken links on mdbook by @lbellomo in https://github.com/uutils/coreutils/pull/7551
* Update installation.md by @AspadaX in https://github.com/uutils/coreutils/pull/7557
* doc: escape RE with backticks (`) by @lbellomo in https://github.com/uutils/coreutils/pull/7560
* performance.md: recommend to build with the right profile by @sylvestre in https://github.com/uutils/coreutils/pull/7930

## Dependency Updates
* Bump `iana-time-zone` & add `windows-core` to skip list by @cakebaker in https://github.com/uutils/coreutils/pull/7628
* deny.toml: remove `zerocopy` from skip list by @cakebaker in https://github.com/uutils/coreutils/pull/7773
* Bump `libc` & remove unnecessary `unsafe` blocks by @cakebaker in https://github.com/uutils/coreutils/pull/7434
* Bump `tempfile` & fix deprecation warning by @cakebaker in https://github.com/uutils/coreutils/pull/7922
* Bump `markdownlint` action & fix warnings by @cakebaker in https://github.com/uutils/coreutils/pull/7939
* Bump `nix` & `ctrlc`, adapt code to API changes in `nix` by @cakebaker in https://github.com/uutils/coreutils/pull/7971
* Bump `fluent` and `fluent-bundle` by @cakebaker in https://github.com/uutils/coreutils/pull/7980
* chore(deps): update rust crate terminal_size to v0.4.2 by @renovate in https://github.com/uutils/coreutils/pull/7425
* chore(deps): update rust crate serde to v1.0.219 by @renovate in https://github.com/uutils/coreutils/pull/7428
* chore(deps): update rust crate clap to v4.5.32 by @renovate in https://github.com/uutils/coreutils/pull/7432
* fix(deps): update rust crate quote to v1.0.40 by @renovate in https://github.com/uutils/coreutils/pull/7436
* fix(deps): update rust crate tempfile to v3.19.0 by @renovate in https://github.com/uutils/coreutils/pull/7444
* chore(deps): update rust crate half to v2.5.0 by @renovate in https://github.com/uutils/coreutils/pull/7445
* chore(deps): update rust crate linux-raw-sys to v0.9.3 by @renovate in https://github.com/uutils/coreutils/pull/7447
* chore(deps): update vmactions/freebsd-vm action to v1.1.9 by @renovate in https://github.com/uutils/coreutils/pull/7456
* chore(deps): update rust crate zip to v2.3.0 by @renovate in https://github.com/uutils/coreutils/pull/7467
* chore(deps): update rust crate zip to v2.4.1 by @renovate in https://github.com/uutils/coreutils/pull/7476
* chore(deps): update rust crate time to v0.3.40 by @renovate in https://github.com/uutils/coreutils/pull/7478
* chore(deps): update rust crate blake3 to v1.7.0 by @renovate in https://github.com/uutils/coreutils/pull/7489
* chore(deps): update rust crate zip to v2.4.2 by @renovate in https://github.com/uutils/coreutils/pull/7491
* chore(deps): update rust crate clap_complete to v4.5.47 by @renovate in https://github.com/uutils/coreutils/pull/7499
* fix(deps): update rust crate tempfile to v3.19.1 by @renovate in https://github.com/uutils/coreutils/pull/7500
* chore(deps): update rust crate chrono-tz to v0.10.2 by @renovate in https://github.com/uutils/coreutils/pull/7543
* chore(deps): update rust crate time to v0.3.41 by @renovate in https://github.com/uutils/coreutils/pull/7549
* chore(deps): update rust crate zip to v2.5.0 by @renovate in https://github.com/uutils/coreutils/pull/7547
* chore(deps): update rust crate iana-time-zone to v0.1.62 by @renovate in https://github.com/uutils/coreutils/pull/7555
* chore(deps): update rust crate chrono-tz to v0.10.3 by @renovate in https://github.com/uutils/coreutils/pull/7561
* chore(deps): update rust crate hex-literal to v1 by @renovate in https://github.com/uutils/coreutils/pull/7343
* chore(deps): update rust crate selinux-sys to v0.6.14 by @renovate in https://github.com/uutils/coreutils/pull/7424
* chore(deps): update rust crate selinux to v0.5.1 by @renovate in https://github.com/uutils/coreutils/pull/7421
* chore(deps): update rust crate fts-sys to v0.2.16 by @renovate in https://github.com/uutils/coreutils/pull/7420
* chore(deps): update rust crate clap to v4.5.34 by @renovate in https://github.com/uutils/coreutils/pull/7588
* chore(deps): update mozilla-actions/sccache-action action to v0.0.9 by @renovate in https://github.com/uutils/coreutils/pull/7592
* fix(deps): update rust crate os_display to v0.1.4 by @renovate in https://github.com/uutils/coreutils/pull/7599
* chore(deps): update reactivecircus/android-emulator-runner action to v2.34.0 by @renovate in https://github.com/uutils/coreutils/pull/7602
* chore(deps): update rust crate blake3 to v1.8.0 by @renovate in https://github.com/uutils/coreutils/pull/7621
* chore(deps): update rust crate clap to v4.5.35 by @renovate in https://github.com/uutils/coreutils/pull/7633
* chore(deps): update rust crate blake3 to v1.8.1 by @renovate in https://github.com/uutils/coreutils/pull/7639
* chore(deps): update rust crate zip to v2.6.0 by @renovate in https://github.com/uutils/coreutils/pull/7644
* chore(deps): update rust crate ctrlc to v3.4.6 by @renovate in https://github.com/uutils/coreutils/pull/7652
* chore(deps): update rust crate smallvec to v1.15.0 by @renovate in https://github.com/uutils/coreutils/pull/7657
* chore(deps): update rust crate zip to v2.6.1 by @renovate in https://github.com/uutils/coreutils/pull/7655
* chore(deps): update vmactions/freebsd-vm action to v1.2.0 by @renovate in https://github.com/uutils/coreutils/pull/7672
* chore(deps): update rust crate crossterm to 0.29.0 by @renovate in https://github.com/uutils/coreutils/pull/7667
* chore(deps): update mozilla-actions/sccache-action action to v0.0.9 by @renovate in https://github.com/uutils/coreutils/pull/7682
* chore(deps): update codecov/codecov-action action to v5 by @renovate in https://github.com/uutils/coreutils/pull/7683
* chore(deps): update rust crate half to v2.6.0 by @renovate in https://github.com/uutils/coreutils/pull/7692
* chore(deps): update rust crate bstr to v1.12.0 by @renovate in https://github.com/uutils/coreutils/pull/7701
* chore(deps): update rust crate linux-raw-sys to v0.9.4 by @renovate in https://github.com/uutils/coreutils/pull/7714
* chore(deps): update rust crate uutils_term_grid to 0.7 by @renovate in https://github.com/uutils/coreutils/pull/7720
* chore(deps): update rust crate self_cell to v1.2.0 by @renovate in https://github.com/uutils/coreutils/pull/7727
* chore(deps): update rust crate clap to v4.5.36 by @renovate in https://github.com/uutils/coreutils/pull/7731
* fix(deps): update rust crate data-encoding to v2.9.0 by @renovate in https://github.com/uutils/coreutils/pull/7735
* fix(deps): update rust crate data-encoding-macro to v0.1.18 by @renovate in https://github.com/uutils/coreutils/pull/7734
* fix(deps): update rust crate libc to v0.2.172 by @renovate in https://github.com/uutils/coreutils/pull/7759
* fix(deps): update rust crate proc-macro2 to v1.0.95 by @renovate in https://github.com/uutils/coreutils/pull/7766
* fix(deps): update rust crate rand to v0.9.1 by @renovate in https://github.com/uutils/coreutils/pull/7772
* chore(deps): update rust crate clap to v4.5.37 by @renovate in https://github.com/uutils/coreutils/pull/7783
* chore(deps): update rust crate blake3 to v1.8.2 by @renovate in https://github.com/uutils/coreutils/pull/7807
* chore(deps): update rust crate ctor to v0.4.2 by @renovate in https://github.com/uutils/coreutils/pull/7817
* chore(deps): update rust crate clap_complete to v4.5.48 by @renovate in https://github.com/uutils/coreutils/pull/7856
* chore(deps): update rust crate sha2 to v0.10.9 by @renovate in https://github.com/uutils/coreutils/pull/7864
* chore(deps): update rust crate clap_complete to v4.5.49 by @renovate in https://github.com/uutils/coreutils/pull/7889
* chore(deps): update rust crate clap_complete to v4.5.50 by @renovate in https://github.com/uutils/coreutils/pull/7893
* chore(deps): update rust crate signal-hook to v0.3.18 by @renovate in https://github.com/uutils/coreutils/pull/7905
* chore(deps): update rust crate clap to v4.5.38 by @renovate in https://github.com/uutils/coreutils/pull/7911
* chore(deps): update rust crate zip to v3 by @renovate in https://github.com/uutils/coreutils/pull/7935
* chore(deps): update rust crate zip to v4 by @renovate in https://github.com/uutils/coreutils/pull/7969


## New Contributors
* @LouisDISPA made their first contribution in https://github.com/uutils/coreutils/pull/7388
* @Carreau made their first contribution in https://github.com/uutils/coreutils/pull/7378
* @ohno418 made their first contribution in https://github.com/uutils/coreutils/pull/7460
* @benyaminl made their first contribution in https://github.com/uutils/coreutils/pull/7453
* @C0rn3j made their first contribution in https://github.com/uutils/coreutils/pull/7462
* @TerakomariGandesblood made their first contribution in https://github.com/uutils/coreutils/pull/7479
* @bloxx12 made their first contribution in https://github.com/uutils/coreutils/pull/7368
* @jmjoy made their first contribution in https://github.com/uutils/coreutils/pull/7506
* @valerioedu made their first contribution in https://github.com/uutils/coreutils/pull/7523
* @usamoi made their first contribution in https://github.com/uutils/coreutils/pull/7521
* @lbellomo made their first contribution in https://github.com/uutils/coreutils/pull/7553
* @AspadaX made their first contribution in https://github.com/uutils/coreutils/pull/7557
* @dlrobertson made their first contribution in https://github.com/uutils/coreutils/pull/7512
* @lewisboon made their first contribution in https://github.com/uutils/coreutils/pull/7548
* @cerdelen made their first contribution in https://github.com/uutils/coreutils/pull/7581
* @ValentinBoudevin made their first contribution in https://github.com/uutils/coreutils/pull/7584
* @GTimothy made their first contribution in https://github.com/uutils/coreutils/pull/7580
* @MoSal made their first contribution in https://github.com/uutils/coreutils/pull/7567
* @kiran-4444 made their first contribution in https://github.com/uutils/coreutils/pull/7545
* @shskwmt made their first contribution in https://github.com/uutils/coreutils/pull/7677
* @CSRessel made their first contribution in https://github.com/uutils/coreutils/pull/7618
* @nyurik made their first contribution in https://github.com/uutils/coreutils/pull/7691
* @MidnightRocket made their first contribution in https://github.com/uutils/coreutils/pull/7617
* @eduardorittner made their first contribution in https://github.com/uutils/coreutils/pull/7656
* @dan-hipschman made their first contribution in https://github.com/uutils/coreutils/pull/7686
* @hz2 made their first contribution in https://github.com/uutils/coreutils/pull/7668
* @evilpie made their first contribution in https://github.com/uutils/coreutils/pull/7743
* @lavafroth made their first contribution in https://github.com/uutils/coreutils/pull/7755
* @emar-kar made their first contribution in https://github.com/uutils/coreutils/pull/7616
* @SergeiPatiakin made their first contribution in https://github.com/uutils/coreutils/pull/7452
* @aaron-ang made their first contribution in https://github.com/uutils/coreutils/pull/7680
* @lukasx999 made their first contribution in https://github.com/uutils/coreutils/pull/7778
* @siddharthteli12 made their first contribution in https://github.com/uutils/coreutils/pull/7786
* @zhw2101024 made their first contribution in https://github.com/uutils/coreutils/pull/7794
* @jplatte made their first contribution in https://github.com/uutils/coreutils/pull/7803
* @frendsick made their first contribution in https://github.com/uutils/coreutils/pull/7810
* @bitspill made their first contribution in https://github.com/uutils/coreutils/pull/7492
* @cptpiepmatz made their first contribution in https://github.com/uutils/coreutils/pull/7840
* @yuankunzhang made their first contribution in https://github.com/uutils/coreutils/pull/7877
* @tdulcet made their first contribution in https://github.com/uutils/coreutils/pull/7888
* @fran-tor made their first contribution in https://github.com/uutils/coreutils/pull/7896

**Full Changelog**: https://github.com/uutils/coreutils/compare/0.0.30...0.1.0
