# Ratatui Widgets

[![Crates.io](https://img.shields.io/crates/v/ratatui-widgets)](https://crates.io/crates/ratatui-widgets)
[![Documentation](https://docs.rs/ratatui-widgets/badge.svg)](https://docs.rs/ratatui-widgets)
[![License](https://img.shields.io/crates/l/ratatui-widgets)](../LICENSE)

<!-- ⚠️ DO NOT EDIT THIS FILE DIRECTLY, EDIT lib.rs AND THEN RUN `cargo rdme` to update this file. -->
<!-- cargo-rdme start -->

**ratatui-widgets** contains all the widgets that were previously part of the [Ratatui] crate.
It is meant to be used in conjunction with `ratatui`, which provides the core functionality for
building terminal user interfaces.

[Ratatui]: https://crates.io/crates/ratatui

Most applications shouldn't need to depend directly on `ratatui-widgets`, `ratatui` crate
re-exports all the widgets from this crate. However, if you are building a widget library that
internally uses these widgets, or if you prefer finer grained dependencies, you may want to
depend on this crate rather than transitively through the `ratatui` crate.

Previously, a crate named `ratatui-widgets` was published with some formative ideas about an
eventual Ratatui framework. That crate has now moved to [tui-framework-experiment], pending a
new name.

[tui-framework-experiment]: https://crates.io/crates/tui-framework-experiment

## Installation

Run the following command to add this crate to your project:

```sh
cargo add ratatui-widgets
```

## Available Widgets

- [`BarChart`]: displays multiple datasets as bars with optional grouping.
- [`Block`]: a basic widget that draws a block with optional borders, titles, and styles.
- [`calendar::Monthly`]: displays a single month.
- [`Canvas`]: draws arbitrary shapes using drawing characters.
- [`Chart`]: displays multiple datasets as lines or scatter graphs.
- [`Clear`]: clears the area it occupies. Useful to render over previously drawn widgets.
- [`Gauge`]: displays progress percentage using block characters.
- [`LineGauge`]: displays progress as a line.
- [`List`]: displays a list of items and allows selection.
- [`RatatuiLogo`]: displays the Ratatui logo.
- [`RatatuiMascot`]: displays the Ratatui mascot.
- [`Paragraph`]: displays a paragraph of optionally styled and wrapped text.
- [`Scrollbar`]: displays a scrollbar.
- [`Sparkline`]: displays a single dataset as a sparkline.
- [`Table`]: displays multiple rows and columns in a grid and allows selection.
- [`Tabs`]: displays a tab bar and allows selection.

[`BarChart`]: https://docs.rs/ratatui-widgets/latest/ratatui_widgets/barchart/struct.BarChart.html
[`Block`]: https://docs.rs/ratatui-widgets/latest/ratatui_widgets/block/struct.Block.html
[`calendar::Monthly`]: https://docs.rs/ratatui-widgets/latest/ratatui_widgets/calendar/struct.Monthly.html
[`Canvas`]: https://docs.rs/ratatui-widgets/latest/ratatui_widgets/canvas/struct.Canvas.html
[`Chart`]: https://docs.rs/ratatui-widgets/latest/ratatui_widgets/chart/struct.Chart.html
[`Clear`]: https://docs.rs/ratatui-widgets/latest/ratatui_widgets/clear/struct.Clear.html
[`Gauge`]: https://docs.rs/ratatui-widgets/latest/ratatui_widgets/gauge/struct.Gauge.html
[`LineGauge`]: https://docs.rs/ratatui-widgets/latest/ratatui_widgets/gauge/struct.LineGauge.html
[`List`]: https://docs.rs/ratatui-widgets/latest/ratatui_widgets/list/struct.List.html
[`RatatuiLogo`]: https://docs.rs/ratatui-widgets/latest/ratatui_widgets/logo/struct.RatatuiLogo.html
[`RatatuiMascot`]: https://docs.rs/ratatui-widgets/latest/ratatui_widgets/mascot/struct.RatatuiMascot.html
[`Paragraph`]: https://docs.rs/ratatui-widgets/latest/ratatui_widgets/paragraph/struct.Paragraph.html
[`Scrollbar`]: https://docs.rs/ratatui-widgets/latest/ratatui_widgets/scrollbar/struct.Scrollbar.html
[`Sparkline`]: https://docs.rs/ratatui-widgets/latest/ratatui_widgets/sparkline/struct.Sparkline.html
[`Table`]: https://docs.rs/ratatui-widgets/latest/ratatui_widgets/table/struct.Table.html
[`Tabs`]: https://docs.rs/ratatui-widgets/latest/ratatui_widgets/tabs/struct.Tabs.html

All these widgets are re-exported directly under `ratatui::widgets` in the `ratatui` crate.

## Crate Organization

`ratatui-widgets` is part of the Ratatui workspace that was modularized in version 0.30.0.
This crate contains all the built-in widget implementations that were previously part of the
main `ratatui` crate.

**When to use `ratatui-widgets`:**

- Building widget libraries that need to compose with built-in widgets
- You want finer-grained dependencies and only need specific widgets
- Creating custom widgets that extend or wrap the built-in ones

**When to use the main [`ratatui`] crate:**

- Building applications (recommended - includes everything you need)
- You want the convenience of having all widgets available

For detailed information about the workspace organization, see [ARCHITECTURE.md].

[`ratatui`]: https://crates.io/crates/ratatui
[ARCHITECTURE.md]: https://github.com/ratatui/ratatui/blob/main/ARCHITECTURE.md

## Contributing

Contributions are welcome! Please open an issue or submit a pull request on GitHub. For more
details on contributing, please see the [CONTRIBUTING](CONTRIBUTING.md) document.

## License

This project is licensed under the MIT License. See the [LICENSE](../LICENSE) file for details.

<!-- cargo-rdme end -->
