/* SPDX-License-Identifier: GPL-2.0-only */

#include <mainboard/gpio.h>
#include <soc/gpio.h>

static const struct pad_config gpio_table[] = {
	/* ------- GPIO Group GPD ------- */
	PAD_CFG_NF(GPD0, UP_20K, PWROK, NF1), // PM_BATLOW#
	PAD_CFG_NF(GPD1, NATIVE, PWROK, NF1), // AC_PRESENT
	PAD_CFG_NF(GPD2, NATIVE, PWROK, NF1), // LAN_WAKEUP#
	PAD_CFG_NF(GPD3, UP_20K, PWROK, NF1), // PWR_BTN#
	PAD_CFG_NF(GPD4, NONE, PWROK, NF1), // SUSB#_PCH
	PAD_CFG_NF(GPD5, NONE, PWROK, NF1), // SUSC#_PCH
	PAD_CFG_NF(GPD6, NONE, PWROK, NF1), // SLP_A#
	PAD_CFG_GPO(GPD7, 0, DEEP), // GPD7_REST
	PAD_CFG_NF(GPD8, NONE, PWROK, NF1), // SUS_CLK
	PAD_CFG_GPO(GPD9, 0, PWROK), // SLP_WLAN#
	PAD_CFG_NF(GPD10, NONE, PWROK, NF1), // SLP_S5#
	PAD_CFG_NF(GPD11, NONE, PWROK, NF1), // LANPHYPC

	/* ------- GPIO Group GPP_A ------- */
	PAD_CFG_NF(GPP_A0, UP_20K, DEEP, NF1), // ESPI_IO0_EC
	PAD_CFG_NF(GPP_A1, UP_20K, DEEP, NF1), // ESPI_IO1_EC
	PAD_CFG_NF(GPP_A2, UP_20K, DEEP, NF1), // ESPI_IO2_EC
	PAD_CFG_NF(GPP_A3, UP_20K, DEEP, NF1), // ESPI_IO3_EC
	PAD_CFG_NF(GPP_A4, UP_20K, DEEP, NF1), // ESPI_CS_EC#
	PAD_CFG_NF(GPP_A5, UP_20K, DEEP, NF1), // ESPI_ALRT0#
	PAD_NC(GPP_A6, NONE),
	PAD_NC(GPP_A7, NONE),
	PAD_CFG_GPO(GPP_A8, 1, PLTRST), // SATA_PWR_EN
	PAD_CFG_NF(GPP_A9, DN_20K, DEEP, NF1), // ESPI_CLK_EC
	PAD_CFG_NF(GPP_A10, NONE, DEEP, NF1), // ESPI_RESET_N
	PAD_NC(GPP_A11, NONE),
	PAD_NC(GPP_A12, NONE),
	PAD_CFG_GPO(GPP_A13, 1, PLTRST), // BT_EN
	//PAD_CFG_GPO(GPP_A14, 0, DEEP), // GPP_A14
	PAD_CFG_NF(GPP_A15, NONE, DEEP, NF2), // PCH_DP_HPD
	PAD_CFG_NF(GPP_A16, NONE, DEEP, NF1), // USB_OC3#
	PAD_CFG_GPI_INT(GPP_A17, NONE, PLTRST, LEVEL), // TP_ATTN#
	PAD_CFG_NF(GPP_A18, NONE, DEEP, NF1), // HDMI_HPD
	PAD_CFG_GPI(GPP_A19, NONE, DEEP), // DGPU_PWROK_PCH
	PAD_CFG_GPO(GPP_A20, 0, DEEP), // PEX_WAKE#
	PAD_NC(GPP_A21, NONE),
	PAD_NC(GPP_A22, NONE),
	PAD_NC(GPP_A23, NONE),

	/* ------- GPIO Group GPP_B ------- */
	PAD_CFG_NF(GPP_B0, NONE, DEEP, NF1), // VCCIN_AUX_VID0
	PAD_CFG_NF(GPP_B1, NONE, DEEP, NF1), // VCCIN_AUX_VID1
	//PAD_CFG_GPO(GPP_B2, 0, DEEP), // DGPU_RST#_PCH
	PAD_CFG_GPI(GPP_B3, NONE, DEEP), // SCI#
	PAD_CFG_GPI(GPP_B4, NONE, DEEP), // SWI#
	PAD_NC(GPP_B5, NONE),
	PAD_NC(GPP_B6, NONE),
	PAD_CFG_GPO(GPP_B7, 1, DEEP), // CARD_PWR_EN
	PAD_CFG_GPO(GPP_B8, 1, DEEP), // CARD_RTD3_RST#
	//PAD_NC(GPP_B9, NONE),
	//PAD_NC(GPP_B10, NONE),
	PAD_NC(GPP_B11, NONE),
	PAD_CFG_NF(GPP_B12, NONE, DEEP, NF1), // SLP_S0#
	PAD_CFG_NF(GPP_B13, NONE, DEEP, NF1), // PLT_RST#
	_PAD_CFG_STRUCT(GPP_B14, 0x44001100, 0x0000), // SATA_LED#
	PAD_NC(GPP_B15, NONE),
	PAD_NC(GPP_B16, NONE),
	PAD_NC(GPP_B17, NONE),
	PAD_CFG_GPO(GPP_B18, 0, DEEP), // GPP_B18_STRAP
	//PAD_NC(GPP_B19, NONE),
	//PAD_NC(GPP_B20, NONE),
	//PAD_NC(GPP_B21, NONE),
	//PAD_NC(GPP_B22, NONE),
	PAD_CFG_GPO(GPP_B23, 0, DEEP), // GPP_B23_STRAP

	/* ------- GPIO Group GPP_C ------- */
	PAD_CFG_NF(GPP_C0, NONE, DEEP, NF1), // SMB_CLK
	PAD_CFG_NF(GPP_C1, NONE, DEEP, NF1), // SMB_DATA
	PAD_CFG_GPO(GPP_C2, 1, PLTRST), // M2_PWR_EN2
	PAD_NC(GPP_C3, NONE), // SML0_CLK
	PAD_NC(GPP_C4, NONE), // SML0_DATA
	PAD_CFG_GPO(GPP_C5, 0, DEEP), // GPP_C5_STRAP
	PAD_NC(GPP_C6, NONE), // TBT_I2C_SCL
	PAD_NC(GPP_C7, NONE), // TBT_I2C_SDA
	//PAD_NC(GPP_C8, NONE),
	//PAD_NC(GPP_C9, NONE),
	//PAD_NC(GPP_C10, NONE),
	//PAD_NC(GPP_C11, NONE),
	//PAD_NC(GPP_C12, NONE),
	//PAD_NC(GPP_C13, NONE),
	//PAD_NC(GPP_C14, NONE),
	//PAD_NC(GPP_C15, NONE),
	//PAD_NC(GPP_C16, NONE),
	//PAD_NC(GPP_C17, NONE),
	//PAD_NC(GPP_C18, NONE),
	//PAD_NC(GPP_C19, NONE),
	//PAD_NC(GPP_C20, NONE),
	//PAD_NC(GPP_C21, NONE),
	//PAD_NC(GPP_C22, NONE),
	//PAD_NC(GPP_C23, NONE),

	/* ------- GPIO Group GPP_D ------- */
	PAD_CFG_GPO(GPP_D0, 1, DEEP), // SB_BLON
	PAD_CFG_GPI(GPP_D1, NONE, DEEP), // SB_KBCRST#
	PAD_NC(GPP_D2, NONE),
	PAD_NC(GPP_D3, NONE),
	PAD_CFG_GPI(GPP_D4, NONE, DEEP), // GPIO_LAN_EN
	//PAD_CFG_NF(GPP_D5, NONE, DEEP, NF1), // SSD0_CLKREQ#
	//PAD_CFG_NF(GPP_D6, NONE, DEEP, NF1), // SSD1_CLKREQ#
	//PAD_CFG_NF(GPP_D7, NONE, DEEP, NF1), // WLAN_CLKREQ#
	//PAD_CFG_NF(GPP_D8, NONE, DEEP, NF1), // GPU_PCIE_CLKREQ#
	PAD_NC(GPP_D9, NONE),
	PAD_NC(GPP_D10, NONE),
	PAD_CFG_NF(GPP_D11, NATIVE, DEEP, NF2), // I_MDP_CLK
	PAD_CFG_NF(GPP_D12, NATIVE, DEEP, NF2), // I_MDP_DATA
	PAD_NC(GPP_D13, NONE),
	PAD_CFG_GPO(GPP_D14, 1, PLTRST), // M2_PWR_EN1
	PAD_CFG_GPO(GPP_D15, 1, DEEP), // LANRTD3_WAKE#
	PAD_CFG_GPO(GPP_D16, 1, PLTRST), // LAN_RTD3_EN#
	PAD_NC(GPP_D17, NONE),
	PAD_NC(GPP_D18, NONE),
	PAD_NC(GPP_D19, NONE),

	/* ------- GPIO Group GPP_E ------- */
	PAD_CFG_GPI(GPP_E0, NONE, DEEP), // CNVI_WAKE#
	//_PAD_CFG_STRUCT(GPP_E1, 0x40100100, 0x3000), // TPM_PIRQ#
	PAD_CFG_GPI(GPP_E2, NONE, DEEP), // BOARD_ID2
	PAD_CFG_GPO(GPP_E3, 1, PLTRST), // PCH_WLAN_EN
	PAD_NC(GPP_E4, NONE),
	PAD_NC(GPP_E5, NONE),
	PAD_CFG_GPO(GPP_E6, 0, DEEP), // GPP_E6_STRAP
	PAD_CFG_GPI(GPP_E7, NONE, DEEP), // SMI#
	PAD_CFG_GPO(GPP_E8, 0, DEEP), // SLP_DRAM#
	PAD_CFG_NF(GPP_E9, NONE, DEEP, NF1), // USB_OC0#
	PAD_CFG_GPO(GPP_E10, 0, DEEP), // KBLED_DET
	PAD_CFG_GPI(GPP_E11, NONE, DEEP), // BOARD_ID1
	PAD_NC(GPP_E12, NONE),
	PAD_CFG_GPO(GPP_E13, 0, DEEP), // BOARD_ID4
	PAD_CFG_NF(GPP_E14, NONE, DEEP, NF1), // EDP_HPD
	PAD_NC(GPP_E15, NONE),
	PAD_NC(GPP_E16, NONE),
	PAD_CFG_GPI(GPP_E17, NONE, DEEP), // BOARD_ID3
	PAD_NC(GPP_E18, NONE),
	PAD_NC(GPP_E19, NONE), // GPP_E19_STRAP
	PAD_NC(GPP_E20, NONE),
	PAD_NC(GPP_E21, NONE),
	PAD_NC(GPP_E22, NONE), // GPP_E21_STRAP
	PAD_NC(GPP_E23, NONE),

	/* ------- GPIO Group GPP_F ------- */
	PAD_CFG_NF(GPP_F0, NONE, DEEP, NF1), // CNVI_BRI_DT
	PAD_CFG_NF(GPP_F1, UP_20K, DEEP, NF1), // CNVI_BRI_RSP
	PAD_CFG_NF(GPP_F2, NONE, DEEP, NF1), // CNVI_RGI_DT
	PAD_CFG_NF(GPP_F3, UP_20K, DEEP, NF1), // CNVI_RGI_RSP
	PAD_CFG_NF(GPP_F4, NONE, DEEP, NF1), // CNVI_RST#
	//PAD_CFG_NF(GPP_F5, NONE, DEEP, NF2), // CNVI_CLKREQ
	PAD_CFG_NF(GPP_F6, NONE, DEEP, NF1), // CNVI_GNSS_PA_BLANKING
	PAD_NC(GPP_F7, NONE),
	//PAD_NC(GPP_F8, NONE),
	PAD_NC(GPP_F9, NONE),
	PAD_CFG_GPO(GPP_F10, 1, DEEP), // PCIE_GLAN_RST#
	PAD_NC(GPP_F11, NONE), // ADDS_CODE
	PAD_CFG_GPI(GPP_F12, NONE, PLTRST), // GPIO4_GC6_NVVDD_EN_R
	PAD_CFG_GPI(GPP_F13, NONE, PLTRST), // GC6_FB_EN_PCH
	PAD_NC(GPP_F14, NONE), // LIGHT_KB_DET#
	PAD_NC(GPP_F15, NONE),
	PAD_CFG_GPI(GPP_F16, NONE, PLTRST), // GPU_EVENT#
	PAD_NC(GPP_F17, NONE),
	PAD_CFG_GPO(GPP_F18, 0, DEEP), // DGPU_OVRM
	//PAD_CFG_NF(GPP_F19, NONE, DEEP, NF1), // GLAN_CLKREQ#
	PAD_CFG_GPO(GPP_F20, 1, PLTRST), // M.2_PLT_RST_CNTRL1#
	PAD_NC(GPP_F21, NONE),
	PAD_CFG_NF(GPP_F22, NONE, DEEP, NF1), // VNN_CTRL
	PAD_CFG_NF(GPP_F23, NONE, DEEP, NF1), // V1P05_CTRL

	/* ------- GPIO Group GPP_H ------- */
	PAD_NC(GPP_H0, NONE),
	PAD_CFG_GPO(GPP_H1, 1, DEEP), // M.2_PLT_RST_CNTRL2#
	PAD_CFG_GPO(GPP_H2, 1, DEEP), // M.2_PLT_RST_CNTRL3#
	PAD_CFG_GPI(GPP_H3, NONE, DEEP), // TPM_DET
	PAD_CFG_NF(GPP_H4, NONE, DEEP, NF1), // I2C_SDA_TP
	PAD_CFG_NF(GPP_H5, NONE, DEEP, NF1), // I2C_SCL_TP
	PAD_CFG_GPI(GPP_H6, NONE, DEEP), // PCH_I2C_SDA
	PAD_CFG_GPI(GPP_H7, NONE, DEEP), // PCH_I2C_SCL
	PAD_CFG_GPO(GPP_H8, 0, DEEP), // CNVI_MFUART2_RXD
	PAD_CFG_GPO(GPP_H9, 0, DEEP), // CNVI_MFUART2_TXD
	//PAD_CFG_NF(GPP_H10, NONE, DEEP, NF1), // UART0_RX
	//PAD_CFG_NF(GPP_H11, NONE, DEEP, NF1), // UART0_TX
	PAD_NC(GPP_H12, NONE),
	_PAD_CFG_STRUCT(GPP_H13, 0x04001500, 0x0000), // DEVSLP1
	//PAD_NC(GPP_H14, NONE),
	PAD_CFG_NF(GPP_H15, NONE, DEEP, NF1), // HDMI_CTRLCLK
	//PAD_NC(GPP_H16, NONE),
	PAD_CFG_NF(GPP_H17, NONE, DEEP, NF1), // HDMI_CTRLDATA
	PAD_CFG_NF(GPP_H18, NONE, DEEP, NF1), // CPU_C10_GATE#
	PAD_NC(GPP_H19, NONE),
	PAD_CFG_NF(GPP_H20, NONE, DEEP, NF1), // PM_CLKRUN#
	PAD_NC(GPP_H21, NONE),
	PAD_NC(GPP_H22, NONE),
	//PAD_CFG_NF(GPP_H23, NONE, DEEP, NF2), // CARD_CLKREQ#

	/* ------- GPIO Group GPP_R ------- */
	PAD_CFG_NF(GPP_R0, NONE, DEEP, NF1), // HDA_BITCLK
	PAD_CFG_NF(GPP_R1, NATIVE, DEEP, NF1), // HDA_SYNC
	PAD_CFG_NF(GPP_R2, NATIVE, DEEP, NF1), // HDA_SDOUT_L
	PAD_CFG_NF(GPP_R3, NATIVE, DEEP, NF1), // HDA_SDIN0
	PAD_CFG_NF(GPP_R4, NONE, DEEP, NF1), // HDA_RST#
	PAD_NC(GPP_R5, NONE),
	PAD_CFG_GPO(GPP_R6, 0, DEEP), // GPPR_DMIC_CLK
	PAD_CFG_GPO(GPP_R7, 0, DEEP), // GPPR_DMIC_DATA

	/* ------- GPIO Group GPP_S ------- */
	PAD_NC(GPP_S0, NONE),
	PAD_NC(GPP_S1, NONE),
	PAD_NC(GPP_S2, NONE),
	PAD_NC(GPP_S3, NONE),
	PAD_NC(GPP_S4, NONE),
	PAD_NC(GPP_S5, NONE),
	PAD_NC(GPP_S6, NONE),
	PAD_NC(GPP_S7, NONE),

	/* ------- GPIO Group GPP_T ------- */
	PAD_NC(GPP_T2, NONE),
	PAD_NC(GPP_T3, NONE),
};

void mainboard_configure_gpios(void)
{
	gpio_configure_pads(gpio_table, ARRAY_SIZE(gpio_table));
}
