struct cpuinfo_mock_file filesystem[] = {
#if CPUINFO_ARCH_ARM64
	{
		.path = "/proc/cpuinfo",
		.size = 243,
		.content = "Processor\t: AArch64 Processor rev 2 (aarch64)\n"
			   "processor\t: 0\n"
			   "BogoMIPS\t: 26.00\n"
			   "Features\t: fp asimd aes pmull sha1 sha2 crc32\n"
			   "CPU implementer\t: 0x41\n"
			   "CPU architecture: AArch64\n"
			   "CPU variant\t: 0x0\n"
			   "CPU part\t: 0xd03\n"
			   "CPU revision\t: 2\n"
			   "\n"
			   "Hardware\t: MT6752\n",
	},
#elif CPUINFO_ARCH_ARM
	{
		.path = "/proc/cpuinfo",
		.size = 303,
		.content =
			"Processor\t: AArch64 Processor rev 2 (aarch64)\n"
			"processor\t: 0\n"
			"BogoMIPS\t: 26.00\n"
			"Features\t: fp asimd aes pmull sha1 sha2 crc32 wp half thumb fastmult vfp edsp neon vfpv3 tlsi vfpv4 idiva idivt \n"
			"CPU implementer\t: 0x41\n"
			"CPU architecture: 8\n"
			"CPU variant\t: 0x0\n"
			"CPU part\t: 0xd03\n"
			"CPU revision\t: 2\n"
			"\n"
			"Hardware\t: MT6752",
	},
#endif
	{
		.path = "/system/build.prop",
		.size = 7780,
		.content =
			"##### Merging of the /util/data/semc_kernel_time_stamp.prop file #####\n"
			"ro.build.date=Sat Dec 12 13:47:11 CST 2015\n"
			"ro.build.date.utc=1449899231\n"
			"ro.build.user=BuildUser\n"
			"ro.build.host=BuildHost\n"
			"\n"
			"##### Final patch of properties #####\n"
			"ro.build.product=arima6752_65_s_l1\n"
			"\n"
			"################# Updating of the SW Version #################\n"
			"ro.semc.version.fs_revision=27.2.B.0.155\n"
			"ro.build.id=27.2.B.0.155\n"
			"ro.build.display.id=27.2.B.0.155\n"
			"\n"
			"##### Values from product package metadata #####\n"
			"ro.semc.product.model=E5333\n"
			"ro.semc.ms_type_id=PM-0862-BV\n"
			"ro.semc.version.fs=GENERIC\n"
			"ro.semc.product.name=Xperia C4 Dual\n"
			"ro.semc.product.device=E53\n"
			"ro.product.model=E5333\n"
			"\n"
			"\n"
			"# begin build properties\n"
			"# autogenerated by buildinfo.sh\n"
			"ro.build.version.incremental=1449899156\n"
			"ro.build.version.sdk=22\n"
			"ro.build.version.codename=REL\n"
			"ro.build.version.all_codenames=REL\n"
			"ro.build.version.release=5.1\n"
			"ro.build.type=user\n"
			"ro.build.tags=test-keys\n"
			"ro.build.flavor=full_arima6752_65_s_l1-user\n"
			"ro.product.brand=alps\n"
			"ro.product.name=full_arima6752_65_s_l1\n"
			"ro.product.device=arima6752_65_s_l1\n"
			"ro.product.board=\n"
			"# ro.product.cpu.abi and ro.product.cpu.abi2 are obsolete,\n"
			"# use ro.product.cpu.abilist instead.\n"
			"ro.product.cpu.abi=arm64-v8a\n"
			"ro.product.cpu.abilist=arm64-v8a,armeabi-v7a,armeabi\n"
			"ro.product.cpu.abilist32=armeabi-v7a,armeabi\n"
			"ro.product.cpu.abilist64=arm64-v8a\n"
			"ro.product.manufacturer=alps\n"
			"ro.product.locale.language=en\n"
			"ro.product.locale.region=US\n"
			"ro.wifi.channels=\n"
			"ro.board.platform=mt6752\n"
			"# ro.build.product is obsolete; use ro.product.device\n"
			"# Do not try to parse description, fingerprint, or thumbprint\n"
			"ro.build.description=full_arima6752_65_s_l1-user 5.1 2.65.J.0.152_201512120913 1449899156 test-keys\n"
			"ro.build.fingerprint=alps/cosmos/cosmos:5.1/2.65.J.0.152_201512120913/1449899156:user/test-keys\n"
			"ro.build.characteristics=default\n"
			"ro.build.imeisv=09\n"
			"ro.build.vendor_sw_ver=2.65.J.0.152_201512120913\n"
			"ro.arima.product_type=cosmos_ds\n"
			"# end build properties\n"
			"ro.mtk_tc1_feature=1\n"
			"persist.radio.hd.voice=1\n"
			"#\n"
			"# from device/arima/arima6752_65_s_l1/system.prop\n"
			"#\n"
			"#\n"
			"# system.prop for generic sdk\n"
			"#\n"
			"\n"
			"rild.libpath=mtk-ril.so\n"
			"rild.libargs=-d /dev/ttyC0\n"
			"\n"
			"\n"
			"# MTK, Infinity, 20090720 {\n"
			"wifi.interface=wlan0\n"
			"# MTK, Infinity, 20090720 }\n"
			"\n"
			"# MTK, mtk03034, 20101210 {\n"
			"ro.mediatek.wlan.wsc=1\n"
			"# MTK, mtk03034 20101210}\n"
			"# MTK, mtk03034, 20110318 {\n"
			"ro.mediatek.wlan.p2p=1\n"
			"# MTK, mtk03034 20110318}\n"
			"\n"
			"# MTK, mtk03034, 20101213 {\n"
			"mediatek.wlan.ctia=0\n"
			"# MTK, mtk03034 20101213}\n"
			"\n"
			"\n"
			"#\n"
			"wifi.tethering.interface=ap0\n"
			"#\n"
			"\n"
			"ro.opengles.version=196608\n"
			"\n"
			"wifi.direct.interface=p2p0\n"
			"dalvik.vm.heapgrowthlimit=256m\n"
			"dalvik.vm.heapsize=512m\n"
			"\n"
			"# USB MTP WHQL\n"
			"ro.sys.usb.mtp.whql.enable=0\n"
			"\n"
			"# Power off opt in IPO\n"
			"sys.ipo.pwrdncap=2\n"
			"\n"
			"ro.sys.usb.storage.type=mtp,mass_storage\n"
			"\n"
			"#<2015/08/03 alreoryuan.To fix issue DMS06681036, add the default value for ro.product.locale.excluded.\n"
			"ro.product.locale.excluded=ar_EG ar_IL fa_IR iw_IL\n"
			"#>2015/08/03 alreoryuan.\n"
			"\n"
			"\n"
			"# USB BICR function\n"
			"ro.sys.usb.bicr=yes\n"
			"\n"
			"# USB Charge only function\n"
			"ro.sys.usb.charging.only=yes\n"
			"\n"
			"# audio\n"
			"ro.camera.sound.forced=0\n"
			"ro.audio.silent=0\n"
			"\n"
			"ro.zygote.preload.enable=0\n"
			"\n"
			"# temporary enables NAV bar (soft keys)\n"
			"qemu.hw.mainkeys=0\n"
			"\n"
			"ro.kernel.zio=38,108,105,16\n"
			"#ro.kernel.qemu=1\n"
			"#ro.kernel.qemu.gles=0\n"
			"#ro.boot.selinux=disable\n"
			"\n"
			"# Disable dirty region for Mali\n"
			"debug.hwui.render_dirty_regions=false\n"
			"\n"
			"ro.sf.lcd_density=480\n"
			"\n"
			"#System props for the MM modules\n"
			"encoder.video.profile=high\n"
			"\n"
			"sony.support.effect=0x1FF\n"
			"\n"
			"#//<2015/03/18-stevenchen, Modify default value of Image enhancement setting\n"
			"#//<2015/03/06-stevenchen, Implement video parameters for Image enhancement\n"
			"#//<2015/02/09-stevenchen, Integrate album parameters for Image enhancement\n"
			"ro.service.xrfm.supported=true\n"
			"persist.service.xrfm.mode=0\n"
			"persist.sys.pq.picmode=3\n"
			"persist.service.swiqi2.enable=0\n"
			"#//>2015/02/09-stevenchen\n"
			"#//>2015/03/06-stevenchen\n"
			"#//<2015/03/18-stevenchen\n"
			"\n"
			"#\n"
			"# ADDITIONAL_BUILD_PROPERTIES\n"
			"#\n"
			"ro.product-res-path=framework/SemcGenericUxpRes/SemcGenericUxpRes.apk\n"
			"ro.com.android.dateformat=MM-dd-yyyy\n"
			"ro.config.ringtone=xperia.ogg\n"
			"ro.config.notification_sound=notification.ogg\n"
			"ro.config.alarm_alert=alarm.ogg\n"
			"ro.carrier=unknown\n"
			"dalvik.vm.heapgrowthlimit=256m\n"
			"dalvik.vm.heapsize=512m\n"
			"ro.mediatek.chip_ver=S01\n"
			"ro.mediatek.version.release=ALPS.L1.MP2.TC9SP.V1_ARIMA6752.65.S.L1_P90\n"
			"ro.mediatek.platform=MT6752\n"
			"ro.telephony.sim.count=2\n"
			"persist.radio.default.sim=0\n"
			"persist.md.perm.checked=to_upgrade\n"
			"persist.gemini.sim_num=2\n"
			"persist.radio.multisim.config=dsds\n"
			"ro.gemini.smart_sim_switch=false\n"
			"ril.specific.sm_cause=1\n"
			"bgw.current3gband=0\n"
			"ril.external.md=0\n"
			"ro.mtk_cam_lomo_support=1\n"
			"ro.btstack=blueangel\n"
			"ro.sf.hwrotation=0\n"
			"ril.current.share_modem=2\n"
			"curlockscreen=1\n"
			"ro.mediatek.gemini_support=true\n"
			"persist.radio.fd.counter=15\n"
			"persist.radio.fd.off.counter=5\n"
			"persist.radio.fd.r8.counter=15\n"
			"persist.radio.fd.off.r8.counter=5\n"
			"drm.service.enabled=true\n"
			"fmradio.driver.enable=1\n"
			"ril.first.md=1\n"
			"ril.flightmode.poweroffMD=0\n"
			"ril.telephony.mode=0\n"
			"dalvik.vm.mtk-stack-trace-file=/data/anr/mtk_traces.txt\n"
			"mediatek.wlan.chip=CONSYS_MT6752\n"
			"mediatek.wlan.module.postfix=_consys_mt6752\n"
			"ril.radiooff.poweroffMD=0\n"
			"ro.mediatek.version.branch=L1.MP2.TC9SP\n"
			"ro.mediatek.version.sdk=4\n"
			"ro.setupwizard.mode=OPTIONAL\n"
			"ro.com.google.gmsversion=5.1_r2\n"
			"ro.com.google.clientidbase=android-sonyericsson\n"
			"ro.com.google.clientidbase.ms=android-sonymobile\n"
			"ro.mtk_gemini_support=1\n"
			"ro.mtk_audenh_support=1\n"
			"ro.mtk_lossless_bt_audio=1\n"
			"ro.mtk_besloudness_support=1\n"
			"ro.mtk_gemini_enhancement=1\n"
			"ro.mtk_wapi_support=1\n"
			"ro.mtk_bt_support=1\n"
			"ro.mtk_wappush_support=1\n"
			"ro.mtk_agps_app=1\n"
			"ro.mtk_voice_ui_support=1\n"
			"ro.mtk_voice_contact_support=1\n"
			"ro.mtk_matv_analog_support=1\n"
			"ro.mtk_wlan_support=1\n"
			"ro.mtk_gps_support=1\n"
			"ro.mtk_omacp_support=1\n"
			"ro.mtk_search_db_support=1\n"
			"ro.mtk_dialer_search_support=1\n"
			"ro.mtk_dhcpv6c_wifi=1\n"
			"ro.have_aacencode_feature=1\n"
			"ro.mtk_fd_support=1\n"
			"persist.data.cc33.support=1\n"
			"ro.mtk_eap_sim_aka=1\n"
			"ro.mtk_fm_recording_support=1\n"
			"ro.mtk_audio_ape_support=1\n"
			"ro.mtk_flv_playback_support=1\n"
			"ro.mtk_wmv_playback_support=1\n"
			"ro.mtk_send_rr_support=1\n"
			"ro.mtk_rat_wcdma_preferred=1\n"
			"ro.mtk_emmc_support=1\n"
			"ro.mtk_fm_50khz_support=1\n"
			"ro.mtk_tetheringipv6_support=1\n"
			"ro.mtk_phone_number_geo=1\n"
			"ro.mtk_shared_sdcard=1\n"
			"ro.mtk_enable_md1=1\n"
			"ro.mtk_pq_support=2\n"
			"ro.mtk_miravision_support=1\n"
			"ro.mtk_wfd_support=1\n"
			"ro.mtk_wfd_sink_support=1\n"
			"ro.mtk_wfd_sink_uibc_support=1\n"
			"ro.mtk_wifi_mcc_support=1\n"
			"ro.mtk_system_update_support=1\n"
			"ro.mtk_sim_hot_swap=1\n"
			"ro.mtk_thumbnail_play_support=1\n"
			"ro.mtk_bip_scws=1\n"
			"ro.mtk_cmcc_ft_precheck_support=1\n"
			"ro.mtk_world_phone_policy=0\n"
			"ro.mtk_perfservice_support=1\n"
			"ro.mtk_mobile_management=1\n"
			"ro.mtk_antibricking_level=2\n"
			"ro.mtk_cam_mfb_support=1\n"
			"ro.mtk_lte_support=1\n"
			"ro.mtk_cam_mav_support=1\n"
			"ro.mtk_cam_vfb=1\n"
			"ro.mtk_subtitle_support=1\n"
			"ro.mtk_live_photo_support=1\n"
			"ro.mtk_motion_track_support=1\n"
			"ro.mtk_slidevideo_support=1\n"
			"ro.mtk_hotknot_support=1\n"
			"ro.mtk_passpoint_r1_support=1\n"
			"ro.mtk_privacy_protection_lock=1\n"
			"ro.mtk_bg_power_saving_support=1\n"
			"ro.mtk_bg_power_saving_ui=1\n"
			"ro.have_aee_feature=1\n"
			"ro.sim_me_lock_mode=0\n"
			"ro.mtk_voice_extension_support=1\n"
			"wfd.dummy.enable=1\n"
			"ro.mediatek.project.path=device/arima/arima6752_65_s_l1\n"
			"ro.mtk_sony_hdcp_support=1\n"
			"ro.sdcrypt.supported=true\n"
			"ro.mtk_trustonic_tee_support=1\n"
			"ro.mtk_sec_video_path_support=1\n"
			"persist.mtk.wcn.combo.chipid=-1\n"
			"service.wcn.driver.ready=no\n"
			"ro.mtk_sensorhub_support=1\n"
			"ro.sony_app2sd_support=1\n"
			"ro.com.android.mobiledata=false\n"
			"persist.radio.mobile.data=0,0\n"
			"persist.meta.dumpdata=0\n"
			"ro.nfc.port=I2C\n"
			"persist.sys.dalvik.vm.lib.2=libart.so\n"
			"dalvik.vm.isa.arm64.features=default\n"
			"dalvik.vm.isa.arm.features=default\n"
			"net.bt.name=Android\n"
			"dalvik.vm.stack-trace-file=/data/anr/traces.txt\n"
			"ro.drm.active.num=7\n"
			"ro.drm.active.0=marlin,1\n"
			"ro.drm.active.1=playready,1\n"
			"ro.drm.active.2=dtla,1\n"
			"ro.drm.active.3=marlin_import,1\n"
			"ro.drm.active.4=ckb,1\n"
			"ro.drm.active.5=widevine,1\n"
			"ro.drm.active.6=dcp,1\n"
			"ro.sony.fota.encrypteddata=supported\n",
	},
	{
		.path = "/sys/devices/system/cpu/kernel_max",
		.size = 2,
		.content = "7\n",
	},
	{
		.path = "/sys/devices/system/cpu/modalias",
		.size = 61,
		.content = "cpu:type:aarch64:feature:,0000,0001,0003,0004,0005,0006,0007\n",
	},
	{
		.path = "/sys/devices/system/cpu/offline",
		.size = 4,
		.content = "1-7\n",
	},
	{
		.path = "/sys/devices/system/cpu/online",
		.size = 2,
		.content = "0\n",
	},
	{
		.path = "/sys/devices/system/cpu/possible",
		.size = 4,
		.content = "0-7\n",
	},
	{
		.path = "/sys/devices/system/cpu/present",
		.size = 4,
		.content = "0-7\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpufreq/all_time_in_state",
		.size = 172,
		.content = "freq\t\tcpu0\t\tcpu1\t\tcpu2\t\tcpu3\t\tcpu4\t\tcpu5\t\tcpu6\t\tcpu7\t\t\n"
			   "468000\t\t2351\t\t\n"
			   "702000\t\t538\t\t\n"
			   "936000\t\t104\t\t\n"
			   "1170000\t\t9954\t\t\n"
			   "1287000\t\t47\t\t\n"
			   "1417000\t\t24\t\t\n"
			   "1560000\t\t48\t\t\n"
			   "1690000\t\t4478\t\t\n",
	},
	{
		.path = "/sys/devices/system/cpu/cputopo/big_cpumask",
		.size = 3,
		.content = "00\n",
	},
	{
		.path = "/sys/devices/system/cpu/cputopo/glbinfo",
		.size = 70,
		.content = "big/little arch: no\n"
			   "big/little cpumask:0/ff\n"
			   "nr_cups: 8\n"
			   "nr_clusters: 2\n",
	},
	{
		.path = "/sys/devices/system/cpu/cputopo/is_big_little",
		.size = 2,
		.content = "0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cputopo/is_multi_cluster",
		.size = 2,
		.content = "1\n",
	},
	{
		.path = "/sys/devices/system/cpu/cputopo/little_cpumask",
		.size = 3,
		.content = "ff\n",
	},
	{
		.path = "/sys/devices/system/cpu/cputopo/nr_clusters",
		.size = 2,
		.content = "2\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/affected_cpus",
		.size = 2,
		.content = "0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/cpuinfo_max_freq",
		.size = 8,
		.content = "1690000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/cpuinfo_min_freq",
		.size = 7,
		.content = "468000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/cpuinfo_transition_latency",
		.size = 5,
		.content = "1000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/related_cpus",
		.size = 16,
		.content = "0 1 2 3 4 5 6 7\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/scaling_available_frequencies",
		.size = 62,
		.content = "1690000 1560000 1417000 1287000 1170000 936000 702000 468000 \n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/scaling_available_governors",
		.size = 54,
		.content = "ondemand userspace powersave interactive performance \n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/scaling_cur_freq",
		.size = 7,
		.content = "468000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/scaling_driver",
		.size = 11,
		.content = "mt-cpufreq\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/scaling_governor",
		.size = 12,
		.content = "interactive\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/scaling_min_freq",
		.size = 7,
		.content = "468000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/stats/time_in_state",
		.size = 93,
		.content = "1690000 4496\n"
			   "1560000 48\n"
			   "1417000 24\n"
			   "1287000 47\n"
			   "1170000 9954\n"
			   "936000 104\n"
			   "702000 538\n"
			   "468000 2479\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/stats/total_trans",
		.size = 4,
		.content = "251\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/stats/trans_table",
		.size = 845,
		.content =
			"   From  :    To\n"
			"         :   1690000   1560000   1417000   1287000   1170000    936000    702000    468000 \n"
			"  1690000:         0         9         6        11        28        14         8        25 \n"
			"  1560000:         7         0         0         1         2         0         0         0 \n"
			"  1417000:         7         1         0         0         0         0         0         0 \n"
			"  1287000:        10         0         2         0         1         1         2         0 \n"
			"  1170000:        27         0         0         4         0         0         0         3 \n"
			"   936000:        10         0         0         0         1         0         6         1 \n"
			"   702000:        15         0         0         0         0         3         0         9 \n"
			"   468000:        25         0         0         0         1         0        11         0 \n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/topology/core_id",
		.size = 2,
		.content = "0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/topology/core_siblings",
		.size = 3,
		.content = "0f\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/topology/core_siblings_list",
		.size = 4,
		.content = "0-3\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/topology/physical_package_id",
		.size = 2,
		.content = "0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/topology/thread_siblings",
		.size = 3,
		.content = "01\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/topology/thread_siblings_list",
		.size = 2,
		.content = "0\n",
	},
	{NULL},
};
#ifdef __ANDROID__
struct cpuinfo_mock_property properties[] = {
	{
		.key = "af.fm.force_direct_mode_type",
		.value = "0",
	},
	{
		.key = "af.policy.r_submix_prio_adjust",
		.value = "0",
	},
	{
		.key = "arima.bk_nv",
		.value = "0",
	},
	{
		.key = "arima.ftboot.ass",
		.value = "0",
	},
	{
		.key = "arima.ftboot",
		.value = "0",
	},
	{
		.key = "arima.nvram.md.sync",
		.value = "1",
	},
	{
		.key = "bgw.current3gband",
		.value = "0",
	},
	{
		.key = "camera.disable_zsl_mode",
		.value = "1",
	},
	{
		.key = "curlockscreen",
		.value = "1",
	},
	{
		.key = "dalvik.vm.dex2oat-Xms",
		.value = "64m",
	},
	{
		.key = "dalvik.vm.dex2oat-Xmx",
		.value = "512m",
	},
	{
		.key = "dalvik.vm.heapgrowthlimit",
		.value = "256m",
	},
	{
		.key = "dalvik.vm.heapsize",
		.value = "512m",
	},
	{
		.key = "dalvik.vm.image-dex2oat-Xms",
		.value = "64m",
	},
	{
		.key = "dalvik.vm.image-dex2oat-Xmx",
		.value = "64m",
	},
	{
		.key = "dalvik.vm.isa.arm.features",
		.value = "default",
	},
	{
		.key = "dalvik.vm.isa.arm64.features",
		.value = "default",
	},
	{
		.key = "dalvik.vm.mtk-stack-trace-file",
		.value = "/data/anr/mtk_traces.txt",
	},
	{
		.key = "dalvik.vm.stack-trace-file",
		.value = "/data/anr/traces.txt",
	},
	{
		.key = "debug.MB.running",
		.value = "0",
	},
	{
		.key = "debug.force_rtl",
		.value = "0",
	},
	{
		.key = "debug.hwc.bq_count",
		.value = "4",
	},
	{
		.key = "debug.hwc.compose_level",
		.value = "0",
	},
	{
		.key = "debug.hwui.render_dirty_regions",
		.value = "false",
	},
	{
		.key = "debug.mdlogger.Running",
		.value = "0",
	},
	{
		.key = "debug.mdlogger.log2sd.path",
		.value = "internal_sd",
	},
	{
		.key = "debug.mtklog.netlog.Running",
		.value = "0",
	},
	{
		.key = "debug.program_binary.enable",
		.value = "1",
	},
	{
		.key = "dev.bootcomplete",
		.value = "1",
	},
	{
		.key = "drm.service.enabled",
		.value = "true",
	},
	{
		.key = "encoder.video.profile",
		.value = "high",
	},
	{
		.key = "fmradio.driver.enable",
		.value = "1",
	},
	{
		.key = "gsm.baseband.capability",
		.value = "503",
	},
	{
		.key = "gsm.current.phone-type",
		.value = "1,1",
	},
	{
		.key = "gsm.gcf.testmode",
		.value = "0",
	},
	{
		.key = "gsm.network.type",
		.value = "Unknown,Unknown",
	},
	{
		.key = "gsm.operator.alpha.2",
		.value = "",
	},
	{
		.key = "gsm.operator.alpha",
		.value = "",
	},
	{
		.key = "gsm.operator.iso-country",
		.value = "",
	},
	{
		.key = "gsm.operator.isroaming",
		.value = "false,false",
	},
	{
		.key = "gsm.operator.numeric",
		.value = "",
	},
	{
		.key = "gsm.project.baseband.2",
		.value = "ARIMA6752_65_S_L1_HW(LWG)",
	},
	{
		.key = "gsm.project.baseband",
		.value = "ARIMA6752_65_S_L1_HW(LWG)",
	},
	{
		.key = "gsm.ril.eboot",
		.value = "-1",
	},
	{
		.key = "gsm.ril.uicctype.2",
		.value = "",
	},
	{
		.key = "gsm.ril.uicctype",
		.value = "",
	},
	{
		.key = "gsm.serial",
		.value = "A303KMT10401",
	},
	{
		.key = "gsm.sim.operator.alpha",
		.value = ",",
	},
	{
		.key = "gsm.sim.operator.default-name.2",
		.value = "",
	},
	{
		.key = "gsm.sim.operator.default-name",
		.value = "",
	},
	{
		.key = "gsm.sim.operator.iso-country",
		.value = ",",
	},
	{
		.key = "gsm.sim.operator.numeric",
		.value = ",",
	},
	{
		.key = "gsm.sim.retry.pin1.2",
		.value = "",
	},
	{
		.key = "gsm.sim.retry.pin1",
		.value = "",
	},
	{
		.key = "gsm.sim.retry.pin2.2",
		.value = "",
	},
	{
		.key = "gsm.sim.retry.pin2",
		.value = "",
	},
	{
		.key = "gsm.sim.retry.puk1.2",
		.value = "",
	},
	{
		.key = "gsm.sim.retry.puk1",
		.value = "",
	},
	{
		.key = "gsm.sim.retry.puk2.2",
		.value = "",
	},
	{
		.key = "gsm.sim.retry.puk2",
		.value = "",
	},
	{
		.key = "gsm.sim.ril.phbready.2",
		.value = "true",
	},
	{
		.key = "gsm.sim.ril.phbready",
		.value = "false",
	},
	{
		.key = "gsm.sim.state",
		.value = "ABSENT,ABSENT",
	},
	{
		.key = "gsm.version.baseband1",
		.value = "MOLY.LR9.W1423.MD.LWTG.MP.V45.P11, 2015/11/09 11:27",
	},
	{
		.key = "gsm.version.baseband",
		.value = "MOLY.LR9.W1423.MD.LWTG.MP.V45.P11, 2015/11/09 11:27",
	},
	{
		.key = "gsm.version.ril-impl",
		.value = "mtk gemini ril 1.0",
	},
	{
		.key = "init.svc.DMAgent",
		.value = "running",
	},
	{
		.key = "init.svc.GoogleOtaAgent",
		.value = "running",
	},
	{
		.key = "init.svc.MtkCodecService",
		.value = "running",
	},
	{
		.key = "init.svc.NvRAMAgent",
		.value = "running",
	},
	{
		.key = "init.svc.PPLAgent",
		.value = "running",
	},
	{
		.key = "init.svc.adbd",
		.value = "running",
	},
	{
		.key = "init.svc.agpsd",
		.value = "running",
	},
	{
		.key = "init.svc.akmd09911",
		.value = "running",
	},
	{
		.key = "init.svc.apfd",
		.value = "running",
	},
	{
		.key = "init.svc.autokd",
		.value = "running",
	},
	{
		.key = "init.svc.batterywarning",
		.value = "running",
	},
	{
		.key = "init.svc.bootanim",
		.value = "stopped",
	},
	{
		.key = "init.svc.bootlogoupdater",
		.value = "stopped",
	},
	{
		.key = "init.svc.ccci2_fsd",
		.value = "stopped",
	},
	{
		.key = "init.svc.ccci2_mdinit",
		.value = "stopped",
	},
	{
		.key = "init.svc.ccci_fsd",
		.value = "running",
	},
	{
		.key = "init.svc.ccci_mdinit",
		.value = "running",
	},
	{
		.key = "init.svc.conn_launcher",
		.value = "running",
	},
	{
		.key = "init.svc.credmgrd",
		.value = "running",
	},
	{
		.key = "init.svc.debuggerd64",
		.value = "running",
	},
	{
		.key = "init.svc.debuggerd",
		.value = "running",
	},
	{
		.key = "init.svc.drm",
		.value = "running",
	},
	{
		.key = "init.svc.emdlogger1",
		.value = "running",
	},
	{
		.key = "init.svc.emsvr_user",
		.value = "running",
	},
	{
		.key = "init.svc.enableswap",
		.value = "stopped",
	},
	{
		.key = "init.svc.firewall-proxy",
		.value = "running",
	},
	{
		.key = "init.svc.fota-trigger",
		.value = "running",
	},
	{
		.key = "init.svc.fuelgauged",
		.value = "running",
	},
	{
		.key = "init.svc.gsm0710muxd",
		.value = "running",
	},
	{
		.key = "init.svc.guiext-server",
		.value = "running",
	},
	{
		.key = "init.svc.healthd",
		.value = "running",
	},
	{
		.key = "init.svc.iddd",
		.value = "running",
	},
	{
		.key = "init.svc.installd",
		.value = "running",
	},
	{
		.key = "init.svc.keystore",
		.value = "running",
	},
	{
		.key = "init.svc.lmkd",
		.value = "running",
	},
	{
		.key = "init.svc.logd",
		.value = "running",
	},
	{
		.key = "init.svc.media",
		.value = "running",
	},
	{
		.key = "init.svc.mnld",
		.value = "running",
	},
	{
		.key = "init.svc.mobicore",
		.value = "running",
	},
	{
		.key = "init.svc.mobile_log_d",
		.value = "running",
	},
	{
		.key = "init.svc.modemsbp2",
		.value = "stopped",
	},
	{
		.key = "init.svc.msensord",
		.value = "stopped",
	},
	{
		.key = "init.svc.mtkbt",
		.value = "running",
	},
	{
		.key = "init.svc.netd",
		.value = "running",
	},
	{
		.key = "init.svc.netdiag",
		.value = "running",
	},
	{
		.key = "init.svc.nvram_daemon",
		.value = "stopped",
	},
	{
		.key = "init.svc.p2p_supplicant",
		.value = "running",
	},
	{
		.key = "init.svc.permission_check",
		.value = "stopped",
	},
	{
		.key = "init.svc.pq",
		.value = "stopped",
	},
	{
		.key = "init.svc.program_binary",
		.value = "running",
	},
	{
		.key = "init.svc.ril-daemon-mtk",
		.value = "running",
	},
	{
		.key = "init.svc.scd",
		.value = "running",
	},
	{
		.key = "init.svc.sdcard",
		.value = "running",
	},
	{
		.key = "init.svc.servicemanager",
		.value = "running",
	},
	{
		.key = "init.svc.sn",
		.value = "running",
	},
	{
		.key = "init.svc.startup-prober",
		.value = "stopped",
	},
	{
		.key = "init.svc.suntrold",
		.value = "stopped",
	},
	{
		.key = "init.svc.suntrold_32",
		.value = "stopped",
	},
	{
		.key = "init.svc.surfaceflinger",
		.value = "running",
	},
	{
		.key = "init.svc.ta_ccci_service",
		.value = "running",
	},
	{
		.key = "init.svc.ta_sync_md",
		.value = "stopped",
	},
	{
		.key = "init.svc.tad_static",
		.value = "running",
	},
	{
		.key = "init.svc.tbase_helperd",
		.value = "stopped",
	},
	{
		.key = "init.svc.terservice",
		.value = "stopped",
	},
	{
		.key = "init.svc.thermal",
		.value = "running",
	},
	{
		.key = "init.svc.thermal_manager",
		.value = "stopped",
	},
	{
		.key = "init.svc.thermald",
		.value = "running",
	},
	{
		.key = "init.svc.ueventd",
		.value = "running",
	},
	{
		.key = "init.svc.update_ta_info",
		.value = "stopped",
	},
	{
		.key = "init.svc.updatemiscta",
		.value = "stopped",
	},
	{
		.key = "init.svc.vold",
		.value = "running",
	},
	{
		.key = "init.svc.wifi2agps",
		.value = "running",
	},
	{
		.key = "init.svc.wmtLoader",
		.value = "stopped",
	},
	{
		.key = "init.svc.xlogboot",
		.value = "stopped",
	},
	{
		.key = "init.svc.xlogdebugchanged",
		.value = "stopped",
	},
	{
		.key = "init.svc.xssm",
		.value = "running",
	},
	{
		.key = "init.svc.zygote",
		.value = "running",
	},
	{
		.key = "init.svc.zygote_secondary",
		.value = "running",
	},
	{
		.key = "media.wfd.portrait",
		.value = "0",
	},
	{
		.key = "media.wfd.video-format",
		.value = "7",
	},
	{
		.key = "mediatek.wlan.chip",
		.value = "CONSYS_MT6752",
	},
	{
		.key = "mediatek.wlan.ctia",
		.value = "0",
	},
	{
		.key = "mediatek.wlan.module.postfix",
		.value = "_consys_mt6752",
	},
	{
		.key = "mtk.md1.starttime",
		.value = "0s Sat Aug 26 01:28:00 2017\r\n",
	},
	{
		.key = "mtk.md1.status",
		.value = "readySat Aug 26 01:28:00 2017\r\n",
	},
	{
		.key = "mtk.md2.status",
		.value = "initSat Aug 26 01:27:57 2017\r\n",
	},
	{
		.key = "mtk_wifi.fwpath",
		.value = "STA",
	},
	{
		.key = "net.bt.name",
		.value = "Android",
	},
	{
		.key = "net.change",
		.value = "net.qtaguid_enabled",
	},
	{
		.key = "net.hostname",
		.value = "android-9da52d616887cf6e",
	},
	{
		.key = "net.nsiot_pending",
		.value = "false",
	},
	{
		.key = "net.qtaguid_enabled",
		.value = "1",
	},
	{
		.key = "net.tcp.default_init_rwnd",
		.value = "60",
	},
	{
		.key = "persist.aee.preserve.main",
		.value = "enable",
	},
	{
		.key = "persist.af.hac_on",
		.value = "0",
	},
	{
		.key = "persist.af.losslessbt.on",
		.value = "0",
	},
	{
		.key = "persist.bt.fwdump",
		.value = "0",
	},
	{
		.key = "persist.data.cc33.support",
		.value = "1",
	},
	{
		.key = "persist.dm.lock",
		.value = "false",
	},
	{
		.key = "persist.gemini.sim_num",
		.value = "2",
	},
	{
		.key = "persist.md.perm.checked",
		.value = "1",
	},
	{
		.key = "persist.meta.dumpdata",
		.value = "0",
	},
	{
		.key = "persist.mtk.wcn.combo.chipid",
		.value = "0x6752",
	},
	{
		.key = "persist.radio.default.sim",
		.value = "0",
	},
	{
		.key = "persist.radio.fd.counter",
		.value = "15",
	},
	{
		.key = "persist.radio.fd.off.counter",
		.value = "5",
	},
	{
		.key = "persist.radio.fd.off.r8.counter",
		.value = "5",
	},
	{
		.key = "persist.radio.fd.r8.counter",
		.value = "15",
	},
	{
		.key = "persist.radio.hd.voice",
		.value = "1",
	},
	{
		.key = "persist.radio.ia-apn",
		.value = "",
	},
	{
		.key = "persist.radio.ia",
		.value = "",
	},
	{
		.key = "persist.radio.mobile.data",
		.value = "0,0",
	},
	{
		.key = "persist.radio.multisim.config",
		.value = "dsds",
	},
	{
		.key = "persist.radio.reset_on_switch",
		.value = "true",
	},
	{
		.key = "persist.radio.simswitch",
		.value = "1",
	},
	{
		.key = "persist.radio.terminal-based.cw",
		.value = "disabled_tbcw,disabled_tbcw",
	},
	{
		.key = "persist.ro.ril.sms_sync_sending",
		.value = "1",
	},
	{
		.key = "persist.service.acm.enable",
		.value = "",
	},
	{
		.key = "persist.service.adb.enable",
		.value = "",
	},
	{
		.key = "persist.service.swiqi2.enable",
		.value = "0",
	},
	{
		.key = "persist.service.xrfm.mode",
		.value = "0",
	},
	{
		.key = "persist.sys.country",
		.value = "US",
	},
	{
		.key = "persist.sys.dalvik.vm.lib.2",
		.value = "libart.so",
	},
	{
		.key = "persist.sys.device_sw_version",
		.value = "27.2.B.0.155",
	},
	{
		.key = "persist.sys.first_time_boot",
		.value = "false",
	},
	{
		.key = "persist.sys.language",
		.value = "en",
	},
	{
		.key = "persist.sys.localevar",
		.value = "",
	},
	{
		.key = "persist.sys.mute.state",
		.value = "2",
	},
	{
		.key = "persist.sys.port_index",
		.value = "",
	},
	{
		.key = "persist.sys.pq.adl.idx",
		.value = "0",
	},
	{
		.key = "persist.sys.pq.picmode",
		.value = "3",
	},
	{
		.key = "persist.sys.pq.shp.idx",
		.value = "2",
	},
	{
		.key = "persist.sys.profiler_ms",
		.value = "0",
	},
	{
		.key = "persist.sys.sd.defaultpath",
		.value = "/storage/emulated/0",
	},
	{
		.key = "persist.sys.usb.config",
		.value = "mtp,adb",
	},
	{
		.key = "persist.tareset.notfirstboot",
		.value = "1",
	},
	{
		.key = "qemu.hw.mainkeys",
		.value = "0",
	},
	{
		.key = "ril.active.md",
		.value = "5",
	},
	{
		.key = "ril.current.share_modem",
		.value = "2",
	},
	{
		.key = "ril.data.allow",
		.value = "0",
	},
	{
		.key = "ril.ecclist1",
		.value = "",
	},
	{
		.key = "ril.ecclist",
		.value = "",
	},
	{
		.key = "ril.external.md",
		.value = "0",
	},
	{
		.key = "ril.fd.mode",
		.value = "1",
	},
	{
		.key = "ril.first.md",
		.value = "1",
	},
	{
		.key = "ril.flightmode.poweroffMD",
		.value = "0",
	},
	{
		.key = "ril.ia.iccid",
		.value = "",
	},
	{
		.key = "ril.iccid.sim1",
		.value = "N/A",
	},
	{
		.key = "ril.iccid.sim2",
		.value = "N/A",
	},
	{
		.key = "ril.ipo.radiooff.2",
		.value = "0",
	},
	{
		.key = "ril.ipo.radiooff",
		.value = "0",
	},
	{
		.key = "ril.mux.ee.md1",
		.value = "0",
	},
	{
		.key = "ril.mux.report.case",
		.value = "0",
	},
	{
		.key = "ril.radiooff.poweroffMD",
		.value = "0",
	},
	{
		.key = "ril.ready.sim",
		.value = "false",
	},
	{
		.key = "ril.specific.sm_cause",
		.value = "1",
	},
	{
		.key = "ril.telephony.mode",
		.value = "0",
	},
	{
		.key = "rild.libargs",
		.value = "-d /dev/ttyC0",
	},
	{
		.key = "rild.libpath",
		.value = "mtk-ril.so",
	},
	{
		.key = "rild.mark_switchuser",
		.value = "0",
	},
	{
		.key = "ro.adb.secure",
		.value = "1",
	},
	{
		.key = "ro.allow.mock.location",
		.value = "0",
	},
	{
		.key = "ro.arima.display.always",
		.value = "-1",
	},
	{
		.key = "ro.arima.id.0",
		.value = "1",
	},
	{
		.key = "ro.arima.id.1",
		.value = "0",
	},
	{
		.key = "ro.arima.id.2",
		.value = "0",
	},
	{
		.key = "ro.arima.id.3",
		.value = "0",
	},
	{
		.key = "ro.arima.imei_1",
		.value = "359099068776508",
	},
	{
		.key = "ro.arima.imei_2",
		.value = "359099068776516",
	},
	{
		.key = "ro.arima.model",
		.value = "5919",
	},
	{
		.key = "ro.arima.product_type",
		.value = "cosmos_ds",
	},
	{
		.key = "ro.arima.startup.check",
		.value = "-2",
	},
	{
		.key = "ro.arima.sw.pcba",
		.value = "0",
	},
	{
		.key = "ro.audio.silent",
		.value = "0",
	},
	{
		.key = "ro.baseband",
		.value = "unknown",
	},
	{
		.key = "ro.board.platform",
		.value = "mt6752",
	},
	{
		.key = "ro.boot.bootloader",
		.value = "s1",
	},
	{
		.key = "ro.boot.bootreason",
		.value = "usb",
	},
	{
		.key = "ro.boot.hardware",
		.value = "mt6752",
	},
	{
		.key = "ro.boot.serialno",
		.value = "WUJ01MXNBC",
	},
	{
		.key = "ro.bootloader",
		.value = "s1",
	},
	{
		.key = "ro.bootmode",
		.value = "unknown",
	},
	{
		.key = "ro.btstack",
		.value = "blueangel",
	},
	{
		.key = "ro.build.characteristics",
		.value = "default",
	},
	{
		.key = "ro.build.date.utc",
		.value = "1449899231",
	},
	{
		.key = "ro.build.date",
		.value = "Sat Dec 12 13:47:11 CST 2015",
	},
	{
		.key = "ro.build.description",
		.value = "E5333-user 5.1 27.2.B.0.155 671280557 release-keys",
	},
	{
		.key = "ro.build.display.id",
		.value = "27.2.B.0.155",
	},
	{
		.key = "ro.build.fingerprint",
		.value = "Sony/E5333/E5333:5.1/27.2.B.0.155/671280557:user/release-keys",
	},
	{
		.key = "ro.build.flavor",
		.value = "full_arima6752_65_s_l1-user",
	},
	{
		.key = "ro.build.host",
		.value = "BuildHost",
	},
	{
		.key = "ro.build.id",
		.value = "27.2.B.0.155",
	},
	{
		.key = "ro.build.imeisv",
		.value = "09",
	},
	{
		.key = "ro.build.product",
		.value = "arima6752_65_s_l1",
	},
	{
		.key = "ro.build.tags",
		.value = "release-keys",
	},
	{
		.key = "ro.build.type",
		.value = "user",
	},
	{
		.key = "ro.build.user",
		.value = "BuildUser",
	},
	{
		.key = "ro.build.vendor_sw_ver",
		.value = "2.65.J.0.152_201512120913",
	},
	{
		.key = "ro.build.version.all_codenames",
		.value = "REL",
	},
	{
		.key = "ro.build.version.codename",
		.value = "REL",
	},
	{
		.key = "ro.build.version.incremental",
		.value = "671280557",
	},
	{
		.key = "ro.build.version.release",
		.value = "5.1",
	},
	{
		.key = "ro.build.version.sdk",
		.value = "22",
	},
	{
		.key = "ro.camera.sound.forced",
		.value = "0",
	},
	{
		.key = "ro.carrier",
		.value = "unknown",
	},
	{
		.key = "ro.com.android.dateformat",
		.value = "MM-dd-yyyy",
	},
	{
		.key = "ro.com.android.mobiledata",
		.value = "false",
	},
	{
		.key = "ro.com.google.clientidbase.ms",
		.value = "android-sonymobile",
	},
	{
		.key = "ro.com.google.clientidbase",
		.value = "android-sonyericsson",
	},
	{
		.key = "ro.com.google.gmsversion",
		.value = "5.1_r2",
	},
	{
		.key = "ro.config.alarm_alert",
		.value = "alarm.ogg",
	},
	{
		.key = "ro.config.notification_sound",
		.value = "notification.ogg",
	},
	{
		.key = "ro.config.ringtone",
		.value = "xperia.ogg",
	},
	{
		.key = "ro.crypto.fuse_sdcard",
		.value = "true",
	},
	{
		.key = "ro.crypto.state",
		.value = "unencrypted",
	},
	{
		.key = "ro.cst.prm",
		.value = "1295-8471:R2A",
	},
	{
		.key = "ro.dalvik.vm.native.bridge",
		.value = "0",
	},
	{
		.key = "ro.debuggable",
		.value = "0",
	},
	{
		.key = "ro.drm.active.0",
		.value = "marlin,1",
	},
	{
		.key = "ro.drm.active.1",
		.value = "playready,1",
	},
	{
		.key = "ro.drm.active.2",
		.value = "dtla,1",
	},
	{
		.key = "ro.drm.active.3",
		.value = "marlin_import,1",
	},
	{
		.key = "ro.drm.active.4",
		.value = "ckb,1",
	},
	{
		.key = "ro.drm.active.5",
		.value = "widevine,1",
	},
	{
		.key = "ro.drm.active.6",
		.value = "dcp,1",
	},
	{
		.key = "ro.drm.active.num",
		.value = "7",
	},
	{
		.key = "ro.factorytest",
		.value = "0",
	},
	{
		.key = "ro.gemini.smart_sim_switch",
		.value = "false",
	},
	{
		.key = "ro.hardware",
		.value = "mt6752",
	},
	{
		.key = "ro.have_aacencode_feature",
		.value = "1",
	},
	{
		.key = "ro.have_aee_feature",
		.value = "1",
	},
	{
		.key = "ro.kernel.zio",
		.value = "38,108,105,16",
	},
	{
		.key = "ro.mediatek.chip_ver",
		.value = "S01",
	},
	{
		.key = "ro.mediatek.gemini_support",
		.value = "true",
	},
	{
		.key = "ro.mediatek.platform",
		.value = "MT6752",
	},
	{
		.key = "ro.mediatek.project.path",
		.value = "device/arima/arima6752_65_s_l1",
	},
	{
		.key = "ro.mediatek.version.branch",
		.value = "L1.MP2.TC9SP",
	},
	{
		.key = "ro.mediatek.version.release",
		.value = "ALPS.L1.MP2.TC9SP.V1_ARIMA6752.65.S.L1_P90",
	},
	{
		.key = "ro.mediatek.version.sdk",
		.value = "4",
	},
	{
		.key = "ro.mediatek.wlan.p2p",
		.value = "1",
	},
	{
		.key = "ro.mediatek.wlan.wsc",
		.value = "1",
	},
	{
		.key = "ro.mount.fs",
		.value = "EXT4",
	},
	{
		.key = "ro.mtk_agps_app",
		.value = "1",
	},
	{
		.key = "ro.mtk_antibricking_level",
		.value = "2",
	},
	{
		.key = "ro.mtk_audenh_support",
		.value = "1",
	},
	{
		.key = "ro.mtk_audio_ape_support",
		.value = "1",
	},
	{
		.key = "ro.mtk_besloudness_support",
		.value = "1",
	},
	{
		.key = "ro.mtk_bg_power_saving_support",
		.value = "1",
	},
	{
		.key = "ro.mtk_bg_power_saving_ui",
		.value = "1",
	},
	{
		.key = "ro.mtk_bip_scws",
		.value = "1",
	},
	{
		.key = "ro.mtk_bt_support",
		.value = "1",
	},
	{
		.key = "ro.mtk_cam_lomo_support",
		.value = "1",
	},
	{
		.key = "ro.mtk_cam_mav_support",
		.value = "1",
	},
	{
		.key = "ro.mtk_cam_mfb_support",
		.value = "1",
	},
	{
		.key = "ro.mtk_cam_vfb",
		.value = "1",
	},
	{
		.key = "ro.mtk_cmcc_ft_precheck_support",
		.value = "1",
	},
	{
		.key = "ro.mtk_dhcpv6c_wifi",
		.value = "1",
	},
	{
		.key = "ro.mtk_dialer_search_support",
		.value = "1",
	},
	{
		.key = "ro.mtk_eap_sim_aka",
		.value = "1",
	},
	{
		.key = "ro.mtk_emmc_support",
		.value = "1",
	},
	{
		.key = "ro.mtk_enable_md1",
		.value = "1",
	},
	{
		.key = "ro.mtk_fd_support",
		.value = "1",
	},
	{
		.key = "ro.mtk_flv_playback_support",
		.value = "1",
	},
	{
		.key = "ro.mtk_fm_50khz_support",
		.value = "1",
	},
	{
		.key = "ro.mtk_fm_recording_support",
		.value = "1",
	},
	{
		.key = "ro.mtk_gemini_enhancement",
		.value = "1",
	},
	{
		.key = "ro.mtk_gemini_support",
		.value = "1",
	},
	{
		.key = "ro.mtk_gps_support",
		.value = "1",
	},
	{
		.key = "ro.mtk_hotknot_support",
		.value = "1",
	},
	{
		.key = "ro.mtk_live_photo_support",
		.value = "1",
	},
	{
		.key = "ro.mtk_lossless_bt_audio",
		.value = "1",
	},
	{
		.key = "ro.mtk_lte_support",
		.value = "1",
	},
	{
		.key = "ro.mtk_matv_analog_support",
		.value = "1",
	},
	{
		.key = "ro.mtk_miravision_support",
		.value = "1",
	},
	{
		.key = "ro.mtk_mobile_management",
		.value = "1",
	},
	{
		.key = "ro.mtk_motion_track_support",
		.value = "1",
	},
	{
		.key = "ro.mtk_omacp_support",
		.value = "1",
	},
	{
		.key = "ro.mtk_passpoint_r1_support",
		.value = "1",
	},
	{
		.key = "ro.mtk_perfservice_support",
		.value = "1",
	},
	{
		.key = "ro.mtk_phone_number_geo",
		.value = "1",
	},
	{
		.key = "ro.mtk_pq_support",
		.value = "2",
	},
	{
		.key = "ro.mtk_privacy_protection_lock",
		.value = "1",
	},
	{
		.key = "ro.mtk_rat_wcdma_preferred",
		.value = "1",
	},
	{
		.key = "ro.mtk_search_db_support",
		.value = "1",
	},
	{
		.key = "ro.mtk_sec_video_path_support",
		.value = "1",
	},
	{
		.key = "ro.mtk_send_rr_support",
		.value = "1",
	},
	{
		.key = "ro.mtk_sensorhub_support",
		.value = "1",
	},
	{
		.key = "ro.mtk_shared_sdcard",
		.value = "1",
	},
	{
		.key = "ro.mtk_sim_hot_swap",
		.value = "1",
	},
	{
		.key = "ro.mtk_slidevideo_support",
		.value = "1",
	},
	{
		.key = "ro.mtk_sony_hdcp_support",
		.value = "1",
	},
	{
		.key = "ro.mtk_subtitle_support",
		.value = "1",
	},
	{
		.key = "ro.mtk_system_update_support",
		.value = "1",
	},
	{
		.key = "ro.mtk_tc1_feature",
		.value = "1",
	},
	{
		.key = "ro.mtk_tetheringipv6_support",
		.value = "1",
	},
	{
		.key = "ro.mtk_thumbnail_play_support",
		.value = "1",
	},
	{
		.key = "ro.mtk_trustonic_tee_support",
		.value = "1",
	},
	{
		.key = "ro.mtk_voice_contact_support",
		.value = "1",
	},
	{
		.key = "ro.mtk_voice_extension_support",
		.value = "1",
	},
	{
		.key = "ro.mtk_voice_ui_support",
		.value = "1",
	},
	{
		.key = "ro.mtk_wapi_support",
		.value = "1",
	},
	{
		.key = "ro.mtk_wappush_support",
		.value = "1",
	},
	{
		.key = "ro.mtk_wfd_sink_support",
		.value = "1",
	},
	{
		.key = "ro.mtk_wfd_sink_uibc_support",
		.value = "1",
	},
	{
		.key = "ro.mtk_wfd_support",
		.value = "1",
	},
	{
		.key = "ro.mtk_wifi_mcc_support",
		.value = "1",
	},
	{
		.key = "ro.mtk_wlan_support",
		.value = "1",
	},
	{
		.key = "ro.mtk_wmv_playback_support",
		.value = "1",
	},
	{
		.key = "ro.mtk_world_phone_policy",
		.value = "0",
	},
	{
		.key = "ro.mtprof.disable",
		.value = "1",
	},
	{
		.key = "ro.nfc.icon.enable",
		.value = "true",
	},
	{
		.key = "ro.nfc.port",
		.value = "I2C",
	},
	{
		.key = "ro.nfc.se.sim.enable",
		.value = "true",
	},
	{
		.key = "ro.nfc.workaround.easycard",
		.value = "false",
	},
	{
		.key = "ro.opengles.version",
		.value = "196608",
	},
	{
		.key = "ro.product-res-path",
		.value = "framework/SemcGenericUxpRes/SemcGenericUxpRes.apk",
	},
	{
		.key = "ro.product.board",
		.value = "",
	},
	{
		.key = "ro.product.brand",
		.value = "Sony",
	},
	{
		.key = "ro.product.cpu.abi",
		.value = "arm64-v8a",
	},
	{
		.key = "ro.product.cpu.abilist32",
		.value = "armeabi-v7a,armeabi",
	},
	{
		.key = "ro.product.cpu.abilist64",
		.value = "arm64-v8a",
	},
	{
		.key = "ro.product.cpu.abilist",
		.value = "arm64-v8a,armeabi-v7a,armeabi",
	},
	{
		.key = "ro.product.device",
		.value = "E5333",
	},
	{
		.key = "ro.product.locale.excluded",
		.value = "ar_EG ar_IL fa_IR iw_IL",
	},
	{
		.key = "ro.product.locale.language",
		.value = "en",
	},
	{
		.key = "ro.product.locale.region",
		.value = "US",
	},
	{
		.key = "ro.product.manufacturer",
		.value = "Sony",
	},
	{
		.key = "ro.product.model",
		.value = "E5333",
	},
	{
		.key = "ro.product.name",
		.value = "E5333",
	},
	{
		.key = "ro.revision",
		.value = "0",
	},
	{
		.key = "ro.runtime.firstboot",
		.value = "1503710910267",
	},
	{
		.key = "ro.sdcrypt.supported",
		.value = "true",
	},
	{
		.key = "ro.secure",
		.value = "1",
	},
	{
		.key = "ro.semc.ms_type_id",
		.value = "PM-0862-BV",
	},
	{
		.key = "ro.semc.product.device",
		.value = "E53",
	},
	{
		.key = "ro.semc.product.model",
		.value = "E5333",
	},
	{
		.key = "ro.semc.product.name",
		.value = "Xperia C4 Dual",
	},
	{
		.key = "ro.semc.version.cust.active",
		.value = "",
	},
	{
		.key = "ro.semc.version.cust",
		.value = "1295-8471",
	},
	{
		.key = "ro.semc.version.cust_revision",
		.value = "R2A",
	},
	{
		.key = "ro.semc.version.fs",
		.value = "GENERIC",
	},
	{
		.key = "ro.semc.version.fs_revision",
		.value = "27.2.B.0.155",
	},
	{
		.key = "ro.semc.version.sw",
		.value = "1292-1559",
	},
	{
		.key = "ro.semc.version.sw_revision",
		.value = "27.2.B.0.155",
	},
	{
		.key = "ro.semc.version.sw_type",
		.value = "user",
	},
	{
		.key = "ro.semc.version.sw_variant",
		.value = "GLOBALDS-LTE",
	},
	{
		.key = "ro.serialno",
		.value = "WUJ01MXNBC",
	},
	{
		.key = "ro.service.xrfm.supported",
		.value = "true",
	},
	{
		.key = "ro.setupwizard.mode",
		.value = "OPTIONAL",
	},
	{
		.key = "ro.sf.hwrotation",
		.value = "0",
	},
	{
		.key = "ro.sf.lcd_density",
		.value = "480",
	},
	{
		.key = "ro.sim_me_lock_mode",
		.value = "0",
	},
	{
		.key = "ro.somc.customerid",
		.value = "442",
	},
	{
		.key = "ro.sony.color_id",
		.value = "",
	},
	{
		.key = "ro.sony.fota.encrypteddata",
		.value = "supported",
	},
	{
		.key = "ro.sony_app2sd_support",
		.value = "1",
	},
	{
		.key = "ro.sys.usb.bicr",
		.value = "yes",
	},
	{
		.key = "ro.sys.usb.charging.only",
		.value = "yes",
	},
	{
		.key = "ro.sys.usb.mtp.whql.enable",
		.value = "0",
	},
	{
		.key = "ro.sys.usb.storage.type",
		.value = "mtp,mass_storage",
	},
	{
		.key = "ro.telephony.sim.count",
		.value = "2",
	},
	{
		.key = "ro.usb.pid_suffix",
		.value = "1D2",
	},
	{
		.key = "ro.wifi.channels",
		.value = "",
	},
	{
		.key = "ro.zygote.preload.enable",
		.value = "0",
	},
	{
		.key = "ro.zygote",
		.value = "zygote64_32",
	},
	{
		.key = "selinux.reload_policy",
		.value = "1",
	},
	{
		.key = "service.bootanim.exit",
		.value = "1",
	},
	{
		.key = "service.nvram_init",
		.value = "Ready",
	},
	{
		.key = "service.wcn.driver.ready",
		.value = "yes",
	},
	{
		.key = "sony.support.effect",
		.value = "0x1FF",
	},
	{
		.key = "sys.boot.reason",
		.value = "0",
	},
	{
		.key = "sys.boot_completed",
		.value = "1",
	},
	{
		.key = "sys.ipo.pwrdncap",
		.value = "2",
	},
	{
		.key = "sys.ipowin.done",
		.value = "1",
	},
	{
		.key = "sys.sysctl.extra_free_kbytes",
		.value = "24300",
	},
	{
		.key = "sys.usb.config",
		.value = "mtp,adb",
	},
	{
		.key = "sys.usb.mtpConnect",
		.value = "mtpConnection",
	},
	{
		.key = "sys.usb.state",
		.value = "mtp,adb",
	},
	{
		.key = "sys.usb.vid",
		.value = "0E8D",
	},
	{
		.key = "vold.path.external_sd",
		.value = "/storage/sdcard1",
	},
	{
		.key = "vold.path.internal_sd",
		.value = "/storage/sdcard0",
	},
	{
		.key = "vold.post_fs_data_done",
		.value = "1",
	},
	{
		.key = "vold.swap.state",
		.value = "0",
	},
	{
		.key = "wfd.dummy.enable",
		.value = "1",
	},
	{
		.key = "wifi.direct.interface",
		.value = "p2p0",
	},
	{
		.key = "wifi.interface",
		.value = "wlan0",
	},
	{
		.key = "wifi.tethering.interface",
		.value = "ap0",
	},
	{
		.key = "wlan.driver.status",
		.value = "ok",
	},
	{
		.key = "wlan.wfd.security.image",
		.value = "1",
	},
	{NULL},
};
#endif /* __ANDROID__ */
