# Contributing to Eclipse Platform

Thanks for your interest in this project.

## Project description

Eclipse Platform defines the set of frameworks and common services that
collectively make up infrastructure required to support the use of Eclipse as a
component model, as a Rich Client Platform (RCP) and as a comprehensive tool
integration platform. These services and frameworks include a standard workbench
user interface model and portable native widget toolkit, a project model for
managing resources, automatic resource delta management for incremental
compilers and builders, language-independent debug infrastructure, and
infrastructure for distributed multi-user versioned resource management.

* https://projects.eclipse.org/projects/eclipse.platform

## Developer resources

Information regarding source code management, builds, coding standards, and
more.

* https://projects.eclipse.org/projects/eclipse.platform/developer

The project maintains the following source code repositories

* http://git.eclipse.org/c/platform/eclipse.platform.common.git
* http://git.eclipse.org/c/platform/eclipse.platform.debug.git
* http://git.eclipse.org/c/platform/eclipse.platform.git
* http://git.eclipse.org/c/platform/eclipse.platform.releng.aggregator.git
* http://git.eclipse.org/c/platform/eclipse.platform.releng.buildtools.git
* http://git.eclipse.org/c/platform/eclipse.platform.releng.git
* http://git.eclipse.org/c/platform/eclipse.platform.swt.git
* http://git.eclipse.org/c/platform/eclipse.platform.swt.binaries.git
* http://git.eclipse.org/c/platform/eclipse.platform.text.git
* http://git.eclipse.org/c/platform/eclipse.platform.ua.git
* http://git.eclipse.org/c/platform/eclipse.platform.ui.git
* http://git.eclipse.org/c/platform/eclipse.platform.ui.tools.git

This project uses Bugzilla to track ongoing development and issues.

* Search for issues: https://github.com/eclipse-platform/eclipse.platform/issues
* Search for old issues: https://eclipse.org/bugs/buglist.cgi?product=Platform
* Create a new report: https://github.com/eclipse-platform/eclipse.platform/issues/new

Be sure to search for existing bugs before you create another one. Remember that
contributions are always welcome!

## Eclipse Contributor Agreement

Before your contribution can be accepted by the project team contributors must
electronically sign the Eclipse Contributor Agreement (ECA).

* http://www.eclipse.org/legal/ECA.php

Commits that are provided by non-committers must have a Signed-off-by field in
the footer indicating that the author is aware of the terms by which the
contribution has been provided to the project. The non-committer must
additionally have an Eclipse Foundation account and must have a signed Eclipse
Contributor Agreement (ECA) on file.

For more information, please see the Eclipse Committer Handbook:
https://www.eclipse.org/projects/handbook/#resources-commit

## Contact

Contact the project developers via the project's "dev" list.

* https://dev.eclipse.org/mailman/listinfo/platform-dev