/*
 * Decompiled with CFR 0.152.
 */
package geotrans3.gui;

import geotrans3.gui.MSP_GEOTRANS3;
import geotrans3.gui.MasterPanel;
import geotrans3.misc.FormatOptions;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import javax.swing.JOptionPane;

public class SaveSettings {
    private MSP_GEOTRANS3 parent;
    private File file;
    private MasterPanel upperMasterPanel;
    private MasterPanel lowerMasterPanel;
    private FileWriter defaultFile;
    private int projectionType = 0;
    private FormatOptions joptions;

    public SaveSettings(MSP_GEOTRANS3 mSP_GEOTRANS3, File file, MasterPanel masterPanel, MasterPanel masterPanel2, FormatOptions formatOptions) {
        this.parent = mSP_GEOTRANS3;
        this.file = file;
        this.upperMasterPanel = masterPanel;
        this.lowerMasterPanel = masterPanel2;
        this.joptions = formatOptions;
        this.writeDefaults();
    }

    private void writeDefaults() {
        try {
            this.defaultFile = new FileWriter(this.file);
            String string = "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\r\n";
            string = string + "<defaults>\r\n";
            this.defaultFile.write(string, 0, string.length());
            this.writeOptions();
            string = "  <source>\r\n";
            string = string + "    <datum>\r\n";
            string = string + "      <index>" + this.upperMasterPanel.getDatumIndex() + "</index>\r\n";
            string = string + "      <code>" + this.upperMasterPanel.getDatumCode() + "</code>\r\n";
            string = string + "    </datum>\r\n";
            string = string + "    <projection>\r\n";
            this.projectionType = this.upperMasterPanel.getProjectionType();
            string = string + "      <index>" + this.projectionType + "</index>\r\n";
            string = string + "      <code>" + this.upperMasterPanel.getProjectionCode() + "</code>\r\n";
            string = string + "    </projection>\r\n";
            this.defaultFile.write(string, 0, string.length());
            this.writeParameters(this.upperMasterPanel);
            string = "  </source>\r\n";
            string = string + "  <target>\r\n";
            string = string + "    <datum>\r\n";
            string = string + "      <index>" + this.lowerMasterPanel.getDatumIndex() + "</index>\r\n";
            string = string + "      <code>" + this.lowerMasterPanel.getDatumCode() + "</code>\r\n";
            string = string + "    </datum>\r\n";
            string = string + "    <projection>\r\n";
            this.projectionType = this.lowerMasterPanel.getProjectionType();
            string = string + "      <index>" + this.projectionType + "</index>\r\n";
            string = string + "      <code>" + this.lowerMasterPanel.getProjectionCode() + "</code>\r\n";
            string = string + "    </projection>\r\n";
            this.defaultFile.write(string, 0, string.length());
            this.writeParameters(this.lowerMasterPanel);
            string = "  </target>\r\n";
            string = string + "</defaults>\r\n";
            this.defaultFile.write(string, 0, string.length());
            this.defaultFile.flush();
            this.defaultFile.close();
            JOptionPane.showMessageDialog(this.parent, "Settings saved!", "Save", 1);
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(this.parent, "Error saving settings!", "Error", 0);
        }
    }

    private void writeParameters(MasterPanel masterPanel) {
        try {
            String string = "    <parameters>\r\n";
            switch (this.projectionType) {
                case 6: 
                case 7: 
                case 20: 
                case 21: 
                case 29: 
                case 36: {
                    string = string + "      <centralMeridian>" + masterPanel.get3ParamCentralMeridian() + "</centralMeridian>\r\n";
                    string = string + "      <falseEasting>" + masterPanel.getFalseEasting() + "</falseEasting>\r\n";
                    string = string + "      <falseNorthing>" + masterPanel.getFalseNorthing() + "</falseNorthing>\r\n";
                    break;
                }
                case 1: 
                case 2: 
                case 4: 
                case 5: 
                case 13: 
                case 25: 
                case 28: 
                case 30: {
                    string = string + "      <centralMeridian>" + masterPanel.get4ParamCentralMeridian() + "</centralMeridian>\r\n";
                    string = string + "      <originLatitude>" + masterPanel.get4ParamOriginLatitude() + "</originLatitude>\r\n";
                    string = string + "      <falseEasting>" + masterPanel.getFalseEasting() + "</falseEasting>\r\n";
                    string = string + "      <falseNorthing>" + masterPanel.getFalseNorthing() + "</falseNorthing>\r\n";
                    break;
                }
                case 8: {
                    string = string + "      <centralMeridian>" + masterPanel.get4ParamCentralMeridian() + "</centralMeridian>\r\n";
                    string = string + "      <standardParallel>" + masterPanel.get4ParamOriginLatitude() + "</standardParallel>\r\n";
                    string = string + "      <falseEasting>" + masterPanel.getFalseEasting() + "</falseEasting>\r\n";
                    string = string + "      <falseNorthing>" + masterPanel.getFalseNorthing() + "</falseNorthing>\r\n";
                    break;
                }
                case 14: {
                    string = string + "      <centralMeridian>" + masterPanel.get5ParamCentralMeridian() + "</centralMeridian>\r\n";
                    string = string + "      <originLatitude>" + masterPanel.get5ParamOriginLatitude() + "</originLatitude>\r\n";
                    string = string + "      <scaleFactor>" + masterPanel.get5ParamScaleFactor() + "</scaleFactor>\r\n";
                    string = string + "      <falseEasting>" + masterPanel.getFalseEasting() + "</falseEasting>\r\n";
                    string = string + "      <falseNorthing>" + masterPanel.getFalseNorthing() + "</falseNorthing>\r\n";
                    break;
                }
                case 31: 
                case 32: {
                    string = string + "      <centralMeridian>" + masterPanel.get5ParamCentralMeridian() + "</centralMeridian>\r\n";
                    string = string + "      <originLatitude>" + masterPanel.get5ParamOriginLatitude() + "</originLatitude>\r\n";
                    string = string + "      <scaleFactor>" + masterPanel.get5ParamScaleFactor() + "</scaleFactor>\r\n";
                    string = string + "      <falseEasting>" + masterPanel.getFalseEasting() + "</falseEasting>\r\n";
                    string = string + "      <falseNorthing>" + masterPanel.getFalseNorthing() + "</falseNorthing>\r\n";
                    break;
                }
                case 17: {
                    string = string + "      <centralMeridian>" + masterPanel.get5ParamCentralMeridian() + "</centralMeridian>\r\n";
                    string = string + "      <standardParallel>" + masterPanel.get5ParamOriginLatitude() + "</standardParallel>\r\n";
                    string = string + "      <scaleFactor>" + masterPanel.get5ParamScaleFactor() + "</scaleFactor>\r\n";
                    string = string + "      <falseEasting>" + masterPanel.getFalseEasting() + "</falseEasting>\r\n";
                    string = string + "      <falseNorthing>" + masterPanel.getFalseNorthing() + "</falseNorthing>\r\n";
                    break;
                }
                case 18: {
                    string = string + "      <centralMeridian>" + masterPanel.get4ParamCentralMeridian() + "</centralMeridian>\r\n";
                    string = string + "      <scaleFactor>" + masterPanel.get4ParamOriginLatitude() + "</scaleFactor>\r\n";
                    string = string + "      <falseEasting>" + masterPanel.getFalseEasting() + "</falseEasting>\r\n";
                    string = string + "      <falseNorthing>" + masterPanel.getFalseNorthing() + "</falseNorthing>\r\n";
                    break;
                }
                case 0: 
                case 15: {
                    string = string + "      <centralMeridian>" + masterPanel.get6ParamCentralMeridian() + "</centralMeridian>\r\n";
                    string = string + "      <originLatitude>" + masterPanel.get6ParamOriginLatitude() + "</originLatitude>\r\n";
                    string = string + "      <standardParallel1>" + masterPanel.get6ParamStandardParallel1() + "</standardParallel1>\r\n";
                    string = string + "      <standardParallel2>" + masterPanel.get6ParamStandardParallel2() + "</standardParallel2>\r\n";
                    string = string + "      <falseEasting>" + masterPanel.getFalseEasting() + "</falseEasting>\r\n";
                    string = string + "      <falseNorthing>" + masterPanel.getFalseNorthing() + "</falseNorthing>\r\n";
                    break;
                }
                case 10: {
                    int n = masterPanel.getGeodeticHeight();
                    if (n == 7) {
                        n = 2;
                    } else if (n < 7 && n >= 2) {
                        ++n;
                    }
                    string = string + "      <heightType>" + n + "</heightType>\r\n";
                    break;
                }
                case 16: {
                    string = string + "      <originLongitude>" + masterPanel.getOriginLongitude() + "</originLongitude>\r\n";
                    string = string + "      <originLatitude>" + masterPanel.getOriginLatitude() + "</originLatitude>\r\n";
                    string = string + "      <originHeight>" + masterPanel.getOriginHeight() + "</originHeight>\r\n";
                    string = string + "      <orientation>" + masterPanel.getOrientation() + "</orientation>\r\n";
                    break;
                }
                case 23: {
                    string = string + "      <centralMeridian>" + masterPanel.getNeysCentralMeridian() + "</centralMeridian>\r\n";
                    string = string + "      <originLatitude>" + masterPanel.getNeysOriginLatitude() + "</originLatitude>\r\n";
                    string = string + "      <standardParallel1>" + masterPanel.getNeysStandardParallel1() + "</standardParallel1>\r\n";
                    string = string + "      <falseEasting>" + masterPanel.getFalseEasting() + "</falseEasting>\r\n";
                    string = string + "      <falseNorthing>" + masterPanel.getFalseNorthing() + "</falseNorthing>\r\n";
                    break;
                }
                case 24: {
                    string = string + "      <originLatitude>" + masterPanel.getOmercOriginLatitude() + "</originLatitude>\r\n";
                    string = string + "      <scaleFactor>" + masterPanel.getOmercScaleFactor() + "</scaleFactor>\r\n";
                    string = string + "      <longitude1>" + masterPanel.getOmercLongitude1() + "</longitude1>\r\n";
                    string = string + "      <latitude1>" + masterPanel.getOmercLatitude1() + "</latitude1>\r\n";
                    string = string + "      <longitude2>" + masterPanel.getOmercLongitude2() + "</longitude2>\r\n";
                    string = string + "      <latitude2>" + masterPanel.getOmercLatitude2() + "</latitude2>\r\n";
                    string = string + "      <falseEasting>" + masterPanel.getOmercFalseEasting() + "</falseEasting>\r\n";
                    string = string + "      <falseNorthing>" + masterPanel.getOmercFalseNorthing() + "</falseNorthing>\r\n";
                    break;
                }
                case 26: {
                    string = string + "      <centralMeridian>" + masterPanel.get4ParamCentralMeridian() + "</centralMeridian>\r\n";
                    string = string + "      <standardParallel>" + masterPanel.get4ParamOriginLatitude() + "</standardParallel>\r\n";
                    string = string + "      <falseEasting>" + masterPanel.getFalseEasting() + "</falseEasting>\r\n";
                    string = string + "      <falseNorthing>" + masterPanel.getFalseNorthing() + "</falseNorthing>\r\n";
                    break;
                }
                case 27: {
                    string = string + "      <centralMeridian>" + masterPanel.getPS_SFCentralMeridian() + "</centralMeridian>\r\n";
                    string = string + "      <scaleFactor>" + masterPanel.getPS_SFScaleFactor() + "</scaleFactor>\r\n";
                    string = string + "      <hemisphere>" + masterPanel.getRow1Hemisphere() + "</hemisphere>\r\n";
                    string = string + "      <falseEasting>" + masterPanel.getFalseEasting() + "</falseEasting>\r\n";
                    string = string + "      <falseNorthing>" + masterPanel.getFalseNorthing() + "</falseNorthing>\r\n";
                    break;
                }
                case 34: {
                    string = string + "      <override>" + masterPanel.getOverride() + "</override>\r\n";
                    string = string + "      <zone>" + masterPanel.getZone() + "</zone>\r\n";
                }
            }
            string = string + "    </parameters>\r\n";
            this.defaultFile.write(string, 0, string.length());
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(this.parent, "Error saving settings!", "Error", 0);
        }
    }

    void writeOptions() {
        try {
            String string = "  <options>\r\n";
            string = string + "    <units>\r\n";
            string = string + "      <index>" + this.joptions.getUnits() + "</index>\r\n";
            string = string + "      <value>" + this.joptions.getUnitsString() + "</value>\r\n";
            string = string + "    </units>\r\n";
            string = string + "    <separator>\r\n";
            string = string + "      <index>" + this.joptions.getSeparatorIndex() + "</index>\r\n";
            string = string + "      <value>" + this.joptions.getSeparator() + "</value>\r\n";
            string = string + "    </separator>\r\n";
            string = string + "    <signHemisphere>\r\n";
            string = string + "      <index>" + this.joptions.getSignHemi() + "</index>\r\n";
            string = string + "      <value>" + this.joptions.getSignHemiString() + "</value>\r\n";
            string = string + "    </signHemisphere>\r\n";
            string = string + "    <longitudeRange>\r\n";
            string = string + "      <index>" + this.joptions.getRange() + "</index>\r\n";
            string = string + "      <value>" + this.joptions.getRangeString() + "</value>\r\n";
            string = string + "    </longitudeRange>\r\n";
            string = string + "    <precision>\r\n";
            string = string + "      <index>" + this.joptions.getPrecision() + "</index>\r\n";
            string = string + "      <value>" + this.joptions.getPrecisionString() + "</value>\r\n";
            string = string + "    </precision>\r\n";
            string = string + "    <leadingZeros>\r\n";
            string = string + "      <value>" + this.joptions.getLeadingZeros() + "</value>\r\n";
            string = string + "    </leadingZeros>\r\n";
            string = string + "    <heightUnit>\r\n";
            string = string + "      <value>" + this.joptions.getHeightUnit() + "</value>\r\n";
            string = string + "    </heightUnit>\r\n";
            string = string + "  </options>\r\n";
            this.defaultFile.write(string, 0, string.length());
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(this.parent, "Error saving settings!", "Error", 0);
        }
    }
}

