// -*- c++ -*-
// Generated by gmmproc 2.39.4 -- DO NOT MODIFY!
#ifndef _WNCKMM_SCREEN_H
#define _WNCKMM_SCREEN_H


#include <glibmm/ustring.h>
#include <sigc++/sigc++.h>

/** This file is part of wnckmm

    Copyright (c) 2013 Povilas Kanapickas  <povilas@radix.lt>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public
    License as published by the Free Software Foundation; either
    version 2.1 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public License
    along with this library.  If not, see <http://www.gnu.org/licenses/>.
*/


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _WnckScreen WnckScreen;
typedef struct _WnckScreenClass WnckScreenClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Wnck
{ class Screen_Class; } // namespace Wnck
namespace Wnck {

class Application;
class ClassGroup;
class Window;
class Workspace;
/** This represents a screen.
 */

class Screen : public Glib::Object
{
    
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef Screen CppObjectType;
  typedef Screen_Class CppClassType;
  typedef WnckScreen BaseObjectType;
  typedef WnckScreenClass BaseClassType;

private:
  friend class Screen_Class;
  static CppClassType screen_class_;

private:
  // noncopyable
  Screen(const Screen&);
  Screen& operator=(const Screen&);

protected:
  explicit Screen(const Glib::ConstructParams& construct_params);
  explicit Screen(WnckScreen* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~Screen();

  /** Get the GType for this class, for use with the underlying GObject type system.
   */
  static GType get_type()      G_GNUC_CONST;

#ifndef DOXYGEN_SHOULD_SKIP_THIS


  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  WnckScreen*       gobj()       { return reinterpret_cast<WnckScreen*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const WnckScreen* gobj() const { return reinterpret_cast<WnckScreen*>(gobject_); }

private:


public:
    
  static Screen* get_default();
    
  static Screen* get(int index);
    
  static Screen* get_for_root(gulong root_id);
    
  int get_number() const;
    
  int get_width() const;
    
  int get_height() const;
    
  void force_update();
    
  std::string get_window_manager_name();
    
  bool net_wm_supports(const std::string& atom);
    
  Window* get_active_window() const;
    
  Window* get_previously_active_window() const;
    
  
  Glib::ListHandle<Window*> get_windows() const;
    
  Glib::ListHandle<Window*> get_windows_stacked() const;

    
  Workspace* get_active_workspace() const;
    // TODO: get_workspaces
    
  Workspace* get_workspace(int workspace) const;
    
  int get_workspace_count() const;
    
  void set_workspace_count(int count) const;

    // TODO: wnck_screen_try_set_workspace_layout
    // TODO: wnck_screen_release_workspace_layout

    
  void move_viewport(int x, int y) const;

    
  gulong get_background_pixmap_xid() const;
    //gtkmmproc error: wnck_screen_is_showing_desktop : method defs lookup failed (1)
    
  void set_showing_desktop(bool show) const;

    
  /**
   * @par Slot Prototype:
   * <tt>void on_my_%active_window_changed(Window* previously_active_window)</tt>
   *
   */

  Glib::SignalProxy1< void,Window* > signal_active_window_changed();

    
  /**
   * @par Slot Prototype:
   * <tt>void on_my_%active_workspace_changed(Workspace* previously_active_workspace)</tt>
   *
   */

  Glib::SignalProxy1< void,Workspace* > signal_active_workspace_changed();

    
  /**
   * @par Slot Prototype:
   * <tt>void on_my_%application_closed(Application* app)</tt>
   *
   */

  Glib::SignalProxy1< void,Application* > signal_application_closed();

    
  /**
   * @par Slot Prototype:
   * <tt>void on_my_%application_opened(Application* app)</tt>
   *
   */

  Glib::SignalProxy1< void,Application* > signal_application_opened();

    
  /**
   * @par Slot Prototype:
   * <tt>void on_my_%backgroupnd_changed()</tt>
   *
   */

  Glib::SignalProxy0< void > signal_backgroupnd_changed();


  /**
   * @par Slot Prototype:
   * <tt>void on_my_%class_group_closed(ClassGroup* app)</tt>
   *
   */

  Glib::SignalProxy1< void,ClassGroup* > signal_class_group_closed();

    
  /**
   * @par Slot Prototype:
   * <tt>void on_my_%class_group_opened(ClassGroup* app)</tt>
   *
   */

  Glib::SignalProxy1< void,ClassGroup* > signal_class_group_opened();

    
  /**
   * @par Slot Prototype:
   * <tt>void on_my_%showing_desktop_changed()</tt>
   *
   */

  Glib::SignalProxy0< void > signal_showing_desktop_changed();

    
  /**
   * @par Slot Prototype:
   * <tt>void on_my_%viewports_changed()</tt>
   *
   */

  Glib::SignalProxy0< void > signal_viewports_changed();


  /**
   * @par Slot Prototype:
   * <tt>void on_my_%window_opened(Window* window)</tt>
   *
   */

  Glib::SignalProxy1< void,Window* > signal_window_opened();

    
  /**
   * @par Slot Prototype:
   * <tt>void on_my_%window_closed(Window* window)</tt>
   *
   */

  Glib::SignalProxy1< void,Window* > signal_window_closed();

    
  /**
   * @par Slot Prototype:
   * <tt>void on_my_%window_manager_changed()</tt>
   *
   */

  Glib::SignalProxy0< void > signal_window_manager_changed();

    
  /**
   * @par Slot Prototype:
   * <tt>void on_my_%window_stacking_changed()</tt>
   *
   */

  Glib::SignalProxy0< void > signal_window_stacking_changed();


  /**
   * @par Slot Prototype:
   * <tt>void on_my_%workspace_created(Workspace* workspace)</tt>
   *
   */

  Glib::SignalProxy1< void,Workspace* > signal_workspace_created();

    
  /**
   * @par Slot Prototype:
   * <tt>void on_my_%workspace_destroyed(Workspace* workspace)</tt>
   *
   */

  Glib::SignalProxy1< void,Workspace* > signal_workspace_destroyed();


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::
  /// This is a default handler for the signal signal_active_window_changed().
  virtual void on_active_window_changed(Window* previously_active_window);
  /// This is a default handler for the signal signal_active_workspace_changed().
  virtual void on_active_workspace_changed(Workspace* previously_active_workspace);
  /// This is a default handler for the signal signal_application_closed().
  virtual void on_application_closed(Application* app);
  /// This is a default handler for the signal signal_application_opened().
  virtual void on_application_opened(Application* app);
  /// This is a default handler for the signal signal_backgroupnd_changed().
  virtual void on_backgroupnd_changed();
  /// This is a default handler for the signal signal_class_group_closed().
  virtual void on_class_group_closed(ClassGroup* app);
  /// This is a default handler for the signal signal_class_group_opened().
  virtual void on_class_group_opened(ClassGroup* app);
  /// This is a default handler for the signal signal_showing_desktop_changed().
  virtual void on_showing_desktop_changed();
  /// This is a default handler for the signal signal_viewports_changed().
  virtual void on_viewports_changed();
  /// This is a default handler for the signal signal_window_opened().
  virtual void on_window_opened(Window* window);
  /// This is a default handler for the signal signal_window_closed().
  virtual void on_window_closed(Window* window);
  /// This is a default handler for the signal signal_window_manager_changed().
  virtual void on_window_manager_changed();
  /// This is a default handler for the signal signal_window_stacking_changed().
  virtual void on_window_stacking_changed();
  /// This is a default handler for the signal signal_workspace_created().
  virtual void on_workspace_created(Workspace* workspace);
  /// This is a default handler for the signal signal_workspace_destroyed().
  virtual void on_workspace_destroyed(Workspace* workspace);


};

} //namespace Wnck


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Wnck::Screen
   */
  Wnck::Screen* wrap(WnckScreen* object, bool take_copy = false);
}


#endif /* _WNCKMM_SCREEN_H */

