/*****************************************************************************
 *
 * This MobilityDB code is provided under The PostgreSQL License.
 * Copyright (c) 2016-2025, Université libre de Bruxelles and MobilityDB
 * contributors
 *
 * MobilityDB includes portions of PostGIS version 3 source code released
 * under the GNU General Public License (GPLv2 or later).
 * Copyright (c) 2001-2025, PostGIS contributors
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose, without fee, and without a written
 * agreement is hereby granted, provided that the above copyright notice and
 * this paragraph and the following two paragraphs appear in all copies.
 *
 * IN NO EVENT SHALL UNIVERSITE LIBRE DE BRUXELLES BE LIABLE TO ANY PARTY FOR
 * DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES, INCLUDING
 * LOST PROFITS, ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION,
 * EVEN IF UNIVERSITE LIBRE DE BRUXELLES HAS BEEN ADVISED OF THE POSSIBILITY
 * OF SUCH DAMAGE.
 *
 * UNIVERSITE LIBRE DE BRUXELLES SPECIFICALLY DISCLAIMS ANY WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS ON
 * AN "AS IS" BASIS, AND UNIVERSITE LIBRE DE BRUXELLES HAS NO OBLIGATIONS TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
 *
 *****************************************************************************/

/**
 * @file
 * @brief Sections for the documentation of the MobilityDB API: Poses
 */

/*****************************************************************************
 * Definition of the modules of the MobilityDB API
 * These modules follow the sections of the MobilityDB documentation although
 * some subsections are merged into a single submodule
 *****************************************************************************/

/**
 * @defgroup mobilitydb_npoint_base Functions for static network points
 * @ingroup mobilitydb_npoint
 * @brief Functions for static network points
 *
 * @defgroup mobilitydb_npoint_set Functions for network point sets
 * @ingroup mobilitydb_npoint
 * @brief Functions for network point sets
 *
 *   @defgroup mobilitydb_npoint_set_conversion Conversion functions
 *   @ingroup mobilitydb_npoint_set
 *   @brief Conversion functions for set and span types
 *
 *   @defgroup mobilitydb_npoint_set_transf Transformation functions
 *   @ingroup mobilitydb_npoint_set
 *   @brief Transformation functions for set and span types
 *
 * @defgroup mobilitydb_npoint_inout Input and output functions
 * @ingroup mobilitydb_npoint
 * @brief Input and output functions for temporal network points
 *
 * @defgroup mobilitydb_npoint_conversion Conversion functions
 * @ingroup mobilitydb_npoint
 * @brief Conversion functions for temporal network points
 *
 * @defgroup mobilitydb_npoint_accessor Accessor functions
 * @ingroup mobilitydb_npoint
 * @brief Accessor functions for temporal network points
 *
 * @defgroup mobilitydb_npoint_restrict Restriction functions
 * @ingroup mobilitydb_npoint
 * @brief Restriction functions for temporal network points
 *
 * @defgroup mobilitydb_npoint_dist Distance functions
 * @ingroup mobilitydb_npoint
 * @brief Distance functions for temporal network points
 *
 * @defgroup mobilitydb_npoint_comp Comparison functions
 * @ingroup mobilitydb_npoint
 * @brief Comparison functions for temporal network points
 *
 *   @defgroup mobilitydb_npoint_comp_ever Ever and always comparison functions
 *   @ingroup mobilitydb_npoint_comp
 *   @brief Ever and always comparison functions for temporal network points
 *
 *   @defgroup mobilitydb_npoint_comp_temp Temporal comparison functions
 *   @ingroup mobilitydb_npoint_comp
 *   @brief Comparison functions for temporal network points
 *
 * @defgroup mobilitydb_npoint_srid Spatial reference system functions
 * @ingroup mobilitydb_npoint
 * @brief Spatial reference system functions for temporal network points
 *
 * @defgroup mobilitydb_npoint_rel Spatial relationship functions
 * @ingroup mobilitydb_npoint
 * @brief Spatial relationship functions for temporal network points
 *
 *   @defgroup mobilitydb_npoint_rel_ever Ever and always spatial relationship functions
 *   @ingroup mobilitydb_npoint_rel
 *   @brief Ever and always spatial relationship functions for temporal network points
 *
 *   @defgroup mobilitydb_npoint_rel_temp Spatiotemporal relationship functions
 *   @ingroup mobilitydb_npoint_rel
 *   @brief Spatiotemporal relationship functions for temporal network points
 *
 *   @defgroup mobilitydb_npoint_route Route functions
 *   @ingroup mobilitydb_npoint
 *   @brief Route functions for temporal network point types
 *
 * @defgroup mobilitydb_npoint_agg Aggregate functions
 * @ingroup mobilitydb_npoint
 * @brief Aggregate functions for temporal network points
 */

/*****************************************************************************/
/**
 * @defgroup mobilitydb_npoint_base_inout Input and output functions
 * @ingroup mobilitydb_npoint_base
 * @brief Input and output functions for static network points
 *
 * @defgroup mobilitydb_npoint_base_constructor Constructor functions
 * @ingroup mobilitydb_npoint_base
 * @brief Constructor functions for static network points
 *
 * @defgroup mobilitydb_npoint_base_conversion Conversion functions
 * @ingroup mobilitydb_npoint_base
 * @brief Conversion functions for static network points
 *
 * @defgroup mobilitydb_npoint_base_accessor Accessor functions
 * @ingroup mobilitydb_npoint_base
 * @brief Accessor functions for static network points
 *
 * @defgroup mobilitydb_npoint_base_transf Transformation functions
 * @ingroup mobilitydb_npoint_base
 * @brief Transformation functions for static network points
 *
 * @defgroup mobilitydb_npoint_base_srid SRID functions
 * @ingroup mobilitydb_npoint_base
 * @brief SRID functions for static network points
 *
 * @defgroup mobilitydb_npoint_base_comp Comparison functions
 * @ingroup mobilitydb_npoint_base
 * @brief Comparison functions for static network points
 */

/*****************************************************************************/

