# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.appcontainers.aio import ContainerAppsAPIClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer
from devtools_testutils.aio import recorded_by_proxy_async

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestContainerAppsAPICertificatesOperationsAsync(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(ContainerAppsAPIClient, is_async=True)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_certificates_list(self, resource_group):
        response = self.client.certificates.list(
            resource_group_name=resource_group.name,
            environment_name="str",
            api_version="2025-02-02-preview",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_certificates_get(self, resource_group):
        response = await self.client.certificates.get(
            resource_group_name=resource_group.name,
            environment_name="str",
            certificate_name="str",
            api_version="2025-02-02-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_certificates_create_or_update(self, resource_group):
        response = await self.client.certificates.create_or_update(
            resource_group_name=resource_group.name,
            environment_name="str",
            certificate_name="str",
            api_version="2025-02-02-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_certificates_delete(self, resource_group):
        response = await self.client.certificates.delete(
            resource_group_name=resource_group.name,
            environment_name="str",
            certificate_name="str",
            api_version="2025-02-02-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_certificates_update(self, resource_group):
        response = await self.client.certificates.update(
            resource_group_name=resource_group.name,
            environment_name="str",
            certificate_name="str",
            certificate_envelope={"tags": {"str": "str"}},
            api_version="2025-02-02-preview",
        )

        # please add some check logic here by yourself
        # ...
