# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.keyvault.aio import KeyVaultManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer
from devtools_testutils.aio import recorded_by_proxy_async

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestKeyVaultManagementSecretsOperationsAsync(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(KeyVaultManagementClient, is_async=True)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_secrets_create_or_update(self, resource_group):
        response = await self.client.secrets.create_or_update(
            resource_group_name=resource_group.name,
            vault_name="str",
            secret_name="str",
            parameters={
                "properties": {
                    "attributes": {
                        "created": "2020-02-20 00:00:00",
                        "enabled": bool,
                        "exp": "2020-02-20 00:00:00",
                        "nbf": "2020-02-20 00:00:00",
                        "updated": "2020-02-20 00:00:00",
                    },
                    "contentType": "str",
                    "secretUri": "str",
                    "secretUriWithVersion": "str",
                    "value": "str",
                },
                "tags": {"str": "str"},
            },
            api_version="2025-05-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_secrets_update(self, resource_group):
        response = await self.client.secrets.update(
            resource_group_name=resource_group.name,
            vault_name="str",
            secret_name="str",
            parameters={
                "properties": {
                    "attributes": {
                        "created": "2020-02-20 00:00:00",
                        "enabled": bool,
                        "exp": "2020-02-20 00:00:00",
                        "nbf": "2020-02-20 00:00:00",
                        "updated": "2020-02-20 00:00:00",
                    },
                    "contentType": "str",
                    "value": "str",
                },
                "tags": {"str": "str"},
            },
            api_version="2025-05-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_secrets_get(self, resource_group):
        response = await self.client.secrets.get(
            resource_group_name=resource_group.name,
            vault_name="str",
            secret_name="str",
            api_version="2025-05-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_secrets_list(self, resource_group):
        response = self.client.secrets.list(
            resource_group_name=resource_group.name,
            vault_name="str",
            api_version="2025-05-01",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...
