# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.compute import ComputeManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestComputeManagementGalleryInVMAccessControlProfileVersionsOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(ComputeManagementClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_gallery_in_vm_access_control_profile_versions_list_by_gallery_in_vm_access_control_profile(
        self, resource_group
    ):
        response = (
            self.client.gallery_in_vm_access_control_profile_versions.list_by_gallery_in_vm_access_control_profile(
                resource_group_name=resource_group.name,
                gallery_name="str",
                in_vm_access_control_profile_name="str",
                api_version="2024-03-03",
            )
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_gallery_in_vm_access_control_profile_versions_get(self, resource_group):
        response = self.client.gallery_in_vm_access_control_profile_versions.get(
            resource_group_name=resource_group.name,
            gallery_name="str",
            in_vm_access_control_profile_name="str",
            in_vm_access_control_profile_version_name="str",
            api_version="2024-03-03",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_gallery_in_vm_access_control_profile_versions_begin_create_or_update(self, resource_group):
        response = self.client.gallery_in_vm_access_control_profile_versions.begin_create_or_update(
            resource_group_name=resource_group.name,
            gallery_name="str",
            in_vm_access_control_profile_name="str",
            in_vm_access_control_profile_version_name="str",
            gallery_in_vm_access_control_profile_version={
                "location": "str",
                "defaultAccess": "str",
                "excludeFromLatest": bool,
                "id": "str",
                "mode": "str",
                "name": "str",
                "provisioningState": "str",
                "publishedDate": "2020-02-20 00:00:00",
                "replicationStatus": {
                    "aggregatedState": "str",
                    "summary": [{"details": "str", "progress": 0, "region": "str", "state": "str"}],
                },
                "rules": {
                    "identities": [
                        {"name": "str", "exePath": "str", "groupName": "str", "processName": "str", "userName": "str"}
                    ],
                    "privileges": [{"name": "str", "path": "str", "queryParameters": {"str": "str"}}],
                    "roleAssignments": [{"identities": ["str"], "role": "str"}],
                    "roles": [{"name": "str", "privileges": ["str"]}],
                },
                "systemData": {
                    "createdAt": "2020-02-20 00:00:00",
                    "createdBy": "str",
                    "createdByType": "str",
                    "lastModifiedAt": "2020-02-20 00:00:00",
                    "lastModifiedBy": "str",
                    "lastModifiedByType": "str",
                },
                "tags": {"str": "str"},
                "targetLocations": [
                    {
                        "name": "str",
                        "additionalReplicaSets": [{"regionalReplicaCount": 0, "storageAccountType": "str"}],
                        "encryption": {
                            "dataDiskImages": [{"lun": 0, "diskEncryptionSetId": "str"}],
                            "osDiskImage": {
                                "diskEncryptionSetId": "str",
                                "securityProfile": {
                                    "confidentialVMEncryptionType": "str",
                                    "secureVMDiskEncryptionSetId": "str",
                                },
                            },
                        },
                        "excludeFromLatest": bool,
                        "regionalReplicaCount": 0,
                        "storageAccountType": "str",
                    }
                ],
                "type": "str",
            },
            api_version="2024-03-03",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_gallery_in_vm_access_control_profile_versions_begin_update(self, resource_group):
        response = self.client.gallery_in_vm_access_control_profile_versions.begin_update(
            resource_group_name=resource_group.name,
            gallery_name="str",
            in_vm_access_control_profile_name="str",
            in_vm_access_control_profile_version_name="str",
            gallery_in_vm_access_control_profile_version={
                "defaultAccess": "str",
                "excludeFromLatest": bool,
                "id": "str",
                "mode": "str",
                "name": "str",
                "provisioningState": "str",
                "publishedDate": "2020-02-20 00:00:00",
                "replicationStatus": {
                    "aggregatedState": "str",
                    "summary": [{"details": "str", "progress": 0, "region": "str", "state": "str"}],
                },
                "rules": {
                    "identities": [
                        {"name": "str", "exePath": "str", "groupName": "str", "processName": "str", "userName": "str"}
                    ],
                    "privileges": [{"name": "str", "path": "str", "queryParameters": {"str": "str"}}],
                    "roleAssignments": [{"identities": ["str"], "role": "str"}],
                    "roles": [{"name": "str", "privileges": ["str"]}],
                },
                "tags": {"str": "str"},
                "targetLocations": [
                    {
                        "name": "str",
                        "additionalReplicaSets": [{"regionalReplicaCount": 0, "storageAccountType": "str"}],
                        "encryption": {
                            "dataDiskImages": [{"lun": 0, "diskEncryptionSetId": "str"}],
                            "osDiskImage": {
                                "diskEncryptionSetId": "str",
                                "securityProfile": {
                                    "confidentialVMEncryptionType": "str",
                                    "secureVMDiskEncryptionSetId": "str",
                                },
                            },
                        },
                        "excludeFromLatest": bool,
                        "regionalReplicaCount": 0,
                        "storageAccountType": "str",
                    }
                ],
                "type": "str",
            },
            api_version="2024-03-03",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_gallery_in_vm_access_control_profile_versions_begin_delete(self, resource_group):
        response = self.client.gallery_in_vm_access_control_profile_versions.begin_delete(
            resource_group_name=resource_group.name,
            gallery_name="str",
            in_vm_access_control_profile_name="str",
            in_vm_access_control_profile_version_name="str",
            api_version="2024-03-03",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...
