# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
# pylint: disable=useless-super-delegation

import datetime
from typing import Any, List, Mapping, Optional, TYPE_CHECKING, Union, overload

from .._utils.model_base import Model as _Model, rest_field

if TYPE_CHECKING:
    from .. import models as _models


class ErrorAdditionalInfo(_Model):
    """The resource management error additional info.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: any
    """

    type: Optional[str] = rest_field(visibility=["read"])
    """The additional info type."""
    info: Optional[Any] = rest_field(visibility=["read"])
    """The additional info."""


class ErrorDetail(_Model):
    """The error detail.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~azure.monitor.querymetrics.models._models.ErrorDetail]
    :ivar additional_info: The error additional info.
    :vartype additional_info: list[~azure.monitor.querymetrics.models._models.ErrorAdditionalInfo]
    """

    code: Optional[str] = rest_field(visibility=["read"])
    """The error code."""
    message: Optional[str] = rest_field(visibility=["read"])
    """The error message."""
    target: Optional[str] = rest_field(visibility=["read"])
    """The error target."""
    details: Optional[List["_models._models.ErrorDetail"]] = rest_field(visibility=["read"])
    """The error details."""
    additional_info: Optional[List["_models._models.ErrorAdditionalInfo"]] = rest_field(
        name="additionalInfo", visibility=["read"]
    )
    """The error additional info."""


class ErrorResponse(_Model):
    """Error response.

    :ivar error: The error object.
    :vartype error: ~azure.monitor.querymetrics.models._models.ErrorDetail
    """

    error: Optional["_models._models.ErrorDetail"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The error object."""

    @overload
    def __init__(
        self,
        *,
        error: Optional["_models._models.ErrorDetail"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class LocalizableString(_Model):
    """The localizable string class.

    :ivar value: The invariant value. Required.
    :vartype value: str
    :ivar localized_value: The display name.
    :vartype localized_value: str
    """

    value: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The invariant value. Required."""
    localized_value: Optional[str] = rest_field(
        name="localizedValue", visibility=["read", "create", "update", "delete", "query"]
    )
    """The display name."""

    @overload
    def __init__(
        self,
        *,
        value: str,
        localized_value: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class MetadataValue(_Model):
    """Represents a metric metadata value.

    :ivar name: The name of the metadata.
    :vartype name: ~azure.monitor.querymetrics.models._models.LocalizableString
    :ivar value: The value of the metadata.
    :vartype value: str
    """

    name: Optional["_models._models.LocalizableString"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The name of the metadata."""
    value: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The value of the metadata."""

    @overload
    def __init__(
        self,
        *,
        name: Optional["_models._models.LocalizableString"] = None,
        value: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class Metric(_Model):
    """The result data of a query.

    :ivar id: The metric Id. Required.
    :vartype id: str
    :ivar type: The resource type of the metric resource. Required.
    :vartype type: str
    :ivar name: The name and the display name of the metric, i.e. it is localizable string.
     Required.
    :vartype name: ~azure.monitor.querymetrics.models._models.LocalizableString
    :ivar display_description: Detailed description of this metric.
    :vartype display_description: str
    :ivar error_code: 'Success' or the error details on query failures for this metric.
    :vartype error_code: str
    :ivar error_message: Error message encountered querying this specific metric.
    :vartype error_message: str
    :ivar unit: The unit of the metric. Required. Known values are: "Count", "Bytes", "Seconds",
     "CountPerSecond", "BytesPerSecond", "Percent", "MilliSeconds", "ByteSeconds", "Unspecified",
     "Cores", "MilliCores", "NanoCores", and "BitsPerSecond".
    :vartype unit: str or ~azure.monitor.querymetrics.models.MetricUnit
    :ivar timeseries: The time series returned when a data query is performed. Required.
    :vartype timeseries: list[~azure.monitor.querymetrics.models._models.TimeSeriesElement]
    """

    id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The metric Id. Required."""
    type: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The resource type of the metric resource. Required."""
    name: "_models._models.LocalizableString" = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The name and the display name of the metric, i.e. it is localizable string. Required."""
    display_description: Optional[str] = rest_field(
        name="displayDescription", visibility=["read", "create", "update", "delete", "query"]
    )
    """Detailed description of this metric."""
    error_code: Optional[str] = rest_field(name="errorCode", visibility=["read", "create", "update", "delete", "query"])
    """'Success' or the error details on query failures for this metric."""
    error_message: Optional[str] = rest_field(
        name="errorMessage", visibility=["read", "create", "update", "delete", "query"]
    )
    """Error message encountered querying this specific metric."""
    unit: Union[str, "_models._enums.MetricUnit"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The unit of the metric. Required. Known values are: \"Count\", \"Bytes\", \"Seconds\",
     \"CountPerSecond\", \"BytesPerSecond\", \"Percent\", \"MilliSeconds\", \"ByteSeconds\",
     \"Unspecified\", \"Cores\", \"MilliCores\", \"NanoCores\", and \"BitsPerSecond\"."""
    timeseries: List["_models._models.TimeSeriesElement"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The time series returned when a data query is performed. Required."""

    @overload
    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
        type: str,
        name: "_models._models.LocalizableString",
        unit: Union[str, "_models._enums.MetricUnit"],
        timeseries: List["_models._models.TimeSeriesElement"],
        display_description: Optional[str] = None,
        error_code: Optional[str] = None,
        error_message: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class MetricResultsResponse(_Model):
    """The metrics result for a resource.

    :ivar values_property: The collection of metric data responses per resource, per metric.
    :vartype values_property:
     list[~azure.monitor.querymetrics.models._models.MetricResultsResponseValuesItem]
    """

    values_property: Optional[List["_models._models.MetricResultsResponseValuesItem"]] = rest_field(
        name="values", visibility=["read", "create", "update", "delete", "query"]
    )
    """The collection of metric data responses per resource, per metric."""

    @overload
    def __init__(
        self,
        *,
        values_property: Optional[List["_models._models.MetricResultsResponseValuesItem"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class MetricResultsResponseValuesItem(_Model):
    """The metric data response for a resource.

    :ivar starttime: The start time, in datetime format, for which the data was retrieved.
     Required.
    :vartype starttime: str
    :ivar endtime: The end time, in datetime format, for which the data was retrieved. Required.
    :vartype endtime: str
    :ivar interval: The interval (window size) for which the metric data was returned in ISO 8601
     duration format with a special case for 'FULL' value that returns single
     datapoint for entire time span requested (*Examples: PT15M, PT1H, P1D, FULL*).
     This may be adjusted and different from what was originally requested if
     AutoAdjustTimegrain=true is specified.
    :vartype interval: str
    :ivar namespace: The namespace of the metrics been queried.
    :vartype namespace: str
    :ivar resourceregion: The region of the resource been queried for metrics.
    :vartype resourceregion: str
    :ivar resourceid: The resource that has been queried for metrics.
    :vartype resourceid: str
    :ivar value: The value of the collection. Required.
    :vartype value: list[~azure.monitor.querymetrics.models._models.Metric]
    """

    starttime: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The start time, in datetime format, for which the data was retrieved. Required."""
    endtime: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The end time, in datetime format, for which the data was retrieved. Required."""
    interval: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The interval (window size) for which the metric data was returned in ISO 8601
     duration format with a special case for 'FULL' value that returns single
     datapoint for entire time span requested (*Examples: PT15M, PT1H, P1D, FULL*).
     This may be adjusted and different from what was originally requested if
     AutoAdjustTimegrain=true is specified."""
    namespace: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The namespace of the metrics been queried."""
    resourceregion: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The region of the resource been queried for metrics."""
    resourceid: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The resource that has been queried for metrics."""
    value: List["_models._models.Metric"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The value of the collection. Required."""

    @overload
    def __init__(
        self,
        *,
        starttime: str,
        endtime: str,
        value: List["_models._models.Metric"],
        interval: Optional[str] = None,
        namespace: Optional[str] = None,
        resourceregion: Optional[str] = None,
        resourceid: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class MetricValue(_Model):
    """Represents a metric value.

    :ivar time_stamp: The timestamp for the metric value in ISO 8601 format. Required.
    :vartype time_stamp: ~datetime.datetime
    :ivar average: The average value in the time range.
    :vartype average: float
    :ivar minimum: The least value in the time range.
    :vartype minimum: float
    :ivar maximum: The greatest value in the time range.
    :vartype maximum: float
    :ivar total: The sum of all of the values in the time range.
    :vartype total: float
    :ivar count: The number of samples in the time range. Can be used to determine the number of
     values that contributed to the average value.
    :vartype count: float
    """

    time_stamp: datetime.datetime = rest_field(
        name="timeStamp", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """The timestamp for the metric value in ISO 8601 format. Required."""
    average: Optional[float] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The average value in the time range."""
    minimum: Optional[float] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The least value in the time range."""
    maximum: Optional[float] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The greatest value in the time range."""
    total: Optional[float] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The sum of all of the values in the time range."""
    count: Optional[float] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The number of samples in the time range. Can be used to determine the number of
     values that contributed to the average value."""

    @overload
    def __init__(
        self,
        *,
        time_stamp: datetime.datetime,
        average: Optional[float] = None,
        minimum: Optional[float] = None,
        maximum: Optional[float] = None,
        total: Optional[float] = None,
        count: Optional[float] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ResourceIdList(_Model):
    """The comma separated list of resource IDs to query metrics for.

    :ivar resourceids: The list of resource IDs to query metrics for.
    :vartype resourceids: list[str]
    """

    resourceids: Optional[List[str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The list of resource IDs to query metrics for."""

    @overload
    def __init__(
        self,
        *,
        resourceids: Optional[List[str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class TimeSeriesElement(_Model):
    """A time series result type. The discriminator value is always TimeSeries in this
    case.

    :ivar metadatavalues: The metadata values returned if $filter was specified in the call.
    :vartype metadatavalues: list[~azure.monitor.querymetrics.models._models.MetadataValue]
    :ivar data: An array of data points representing the metric values.  This is only returned
     if a result type of data is specified.
    :vartype data: list[~azure.monitor.querymetrics.models._models.MetricValue]
    """

    metadatavalues: Optional[List["_models._models.MetadataValue"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The metadata values returned if $filter was specified in the call."""
    data: Optional[List["_models._models.MetricValue"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """An array of data points representing the metric values.  This is only returned
     if a result type of data is specified."""

    @overload
    def __init__(
        self,
        *,
        metadatavalues: Optional[List["_models._models.MetadataValue"]] = None,
        data: Optional[List["_models._models.MetricValue"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
