
// std lib related includes
#include <tuple>

// pybind 11 related includes
#include <pybind11/pybind11.h>
#include <pybind11/stl.h>

namespace py = pybind11;

// Standard Handle
#include <Standard_Handle.hxx>


// includes to resolve forward declarations
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <TDF_Label.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <XCAFPrs_Style.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <TDocStd_Document.hxx>
#include <XCAFDoc_ColorTool.hxx>
#include <XCAFDoc_VisMaterialTool.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <TDF_Label.hxx>
#include <AIS_InteractiveObject.hxx>
#include <Standard_GUID.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>

// module includes
#include <XCAFPrs.hxx>
#include <XCAFPrs_AISObject.hxx>
#include <XCAFPrs_DataMapIteratorOfDataMapOfStyleShape.hxx>
#include <XCAFPrs_DataMapIteratorOfDataMapOfStyleTransient.hxx>
#include <XCAFPrs_DataMapIteratorOfIndexedDataMapOfShapeStyle.hxx>
#include <XCAFPrs_DataMapOfStyleShape.hxx>
#include <XCAFPrs_DataMapOfStyleTransient.hxx>
#include <XCAFPrs_DocumentExplorer.hxx>
#include <XCAFPrs_DocumentIdIterator.hxx>
#include <XCAFPrs_DocumentNode.hxx>
#include <XCAFPrs_Driver.hxx>
#include <XCAFPrs_IndexedDataMapOfShapeStyle.hxx>
#include <XCAFPrs_Style.hxx>
#include <XCAFPrs_Texture.hxx>

// template related includes

// ./opencascade/XCAFPrs_DataMapOfStyleShape.hxx
#include "NCollection_tmpl.hxx"

// ./opencascade/XCAFPrs_DataMapOfStyleShape.hxx
#include "NCollection_tmpl.hxx"

// ./opencascade/XCAFPrs_DataMapOfStyleTransient.hxx
#include "NCollection_tmpl.hxx"

// ./opencascade/XCAFPrs_IndexedDataMapOfShapeStyle.hxx
#include "NCollection_tmpl.hxx"

// ./opencascade/XCAFPrs_IndexedDataMapOfShapeStyle.hxx
#include "NCollection_tmpl.hxx"


// user-defined pre
#include "OCP_specific.inc"

// user-defined inclusion per module
#include <Image_SupportedFormats.hxx>
#include <Image_CompressedPixMap.hxx>

// Module definiiton
void register_XCAFPrs(py::module &main_module) {


py::module m = static_cast<py::module>(main_module.attr("XCAFPrs"));
py::object klass;

//Python trampoline classes

// classes

    // Class XCAFPrs from ./opencascade/XCAFPrs.hxx
    klass = m.attr("XCAFPrs");

    // default constructor
    register_default_constructor<XCAFPrs , shared_ptr<XCAFPrs>>(m,"XCAFPrs");

    // nested enums

    static_cast<py::class_<XCAFPrs , shared_ptr<XCAFPrs>  >>(klass)
    // constructors
    // custom constructors
    // methods
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("CollectStyleSettings_s",
                    (void (*)( const TDF_Label & ,  const TopLoc_Location & ,  NCollection_IndexedDataMap<TopoDS_Shape, XCAFPrs_Style, TopTools_ShapeMapHasher> & ,  const Quantity_ColorRGBA &  ) ) static_cast<void (*)( const TDF_Label & ,  const TopLoc_Location & ,  NCollection_IndexedDataMap<TopoDS_Shape, XCAFPrs_Style, TopTools_ShapeMapHasher> & ,  const Quantity_ColorRGBA &  ) >(&XCAFPrs::CollectStyleSettings),
                    R"#(Collect styles defined for shape on label L and its components and subshapes and fills a map of shape - style correspondence The location <loc> is for internal use, it should be Null location for external call)#"  , py::arg("L"),  py::arg("loc"),  py::arg("settings"),  py::arg("theLayerColor")=static_cast<const Quantity_ColorRGBA &>(Quantity_ColorRGBA ( Quantity_NOC_WHITE ))
          )
        .def_static("SetViewNameMode_s",
                    (void (*)( const Standard_Boolean  ) ) static_cast<void (*)( const Standard_Boolean  ) >(&XCAFPrs::SetViewNameMode),
                    R"#(Set ViewNameMode for indicate display names or not.)#"  , py::arg("viewNameMode")
          )
        .def_static("GetViewNameMode_s",
                    (Standard_Boolean (*)() ) static_cast<Standard_Boolean (*)() >(&XCAFPrs::GetViewNameMode),
                    R"#(None)#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
;

    // Class XCAFPrs_AISObject from ./opencascade/XCAFPrs_AISObject.hxx
    klass = m.attr("XCAFPrs_AISObject");


    // nested enums

    static_cast<py::class_<XCAFPrs_AISObject ,opencascade::handle<XCAFPrs_AISObject>  , AIS_ColoredShape >>(klass)
    // constructors
        .def(py::init< const TDF_Label & >()  , py::arg("theLabel") )
    // custom constructors
    // methods
        .def("SetLabel",
             (void (XCAFPrs_AISObject::*)( const TDF_Label &  ) ) static_cast<void (XCAFPrs_AISObject::*)( const TDF_Label &  ) >(&XCAFPrs_AISObject::SetLabel),
             R"#(Assign the label to this presentation (but does not mark it outdated with SetToUpdate()).)#"  , py::arg("theLabel")
          )
        .def("DispatchStyles",
             (void (XCAFPrs_AISObject::*)( const Standard_Boolean  ) ) static_cast<void (XCAFPrs_AISObject::*)( const Standard_Boolean  ) >(&XCAFPrs_AISObject::DispatchStyles),
             R"#(Fetch the Shape from associated Label and fill the map of sub-shapes styles. By default, this method is called implicitly within first ::Compute(). Application might call this method explicitly to manipulate styles afterwards.)#"  , py::arg("theToSyncStyles")=static_cast<const Standard_Boolean>(Standard_False)
          )
        .def("SetMaterial",
             (void (XCAFPrs_AISObject::*)( const Graphic3d_MaterialAspect &  ) ) static_cast<void (XCAFPrs_AISObject::*)( const Graphic3d_MaterialAspect &  ) >(&XCAFPrs_AISObject::SetMaterial),
             R"#(Sets the material aspect. This method assigns the new default material without overriding XDE styles. Re-computation of existing presentation is not required after calling this method.)#"  , py::arg("theMaterial")
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("get_type_name_s",
                    (const char * (*)() ) static_cast<const char * (*)() >(&XCAFPrs_AISObject::get_type_name),
                    R"#(None)#" 
          )
        .def_static("get_type_descriptor_s",
                    (const opencascade::handle<Standard_Type> & (*)() ) static_cast<const opencascade::handle<Standard_Type> & (*)() >(&XCAFPrs_AISObject::get_type_descriptor),
                    R"#(None)#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("GetLabel",
             (const TDF_Label & (XCAFPrs_AISObject::*)() const) static_cast<const TDF_Label & (XCAFPrs_AISObject::*)() const>(&XCAFPrs_AISObject::GetLabel),
             R"#(Returns the label which was visualised by this presentation)#"
             
         )
       .def("DynamicType",
             (const opencascade::handle<Standard_Type> & (XCAFPrs_AISObject::*)() const) static_cast<const opencascade::handle<Standard_Type> & (XCAFPrs_AISObject::*)() const>(&XCAFPrs_AISObject::DynamicType),
             R"#(None)#"
             
         )
;

    // Class XCAFPrs_DocumentExplorer from ./opencascade/XCAFPrs_DocumentExplorer.hxx
    klass = m.attr("XCAFPrs_DocumentExplorer");


    // nested enums

    static_cast<py::class_<XCAFPrs_DocumentExplorer , shared_ptr<XCAFPrs_DocumentExplorer>  >>(klass)
    // constructors
        .def(py::init<  >()  )
        .def(py::init< const opencascade::handle<TDocStd_Document> &,const XCAFPrs_DocumentExplorerFlags,const XCAFPrs_Style & >()  , py::arg("theDocument"),  py::arg("theFlags"),  py::arg("theDefStyle")=static_cast<const XCAFPrs_Style &>(XCAFPrs_Style ( )) )
        .def(py::init< const opencascade::handle<TDocStd_Document> &, const NCollection_Sequence<TDF_Label> &,const XCAFPrs_DocumentExplorerFlags,const XCAFPrs_Style & >()  , py::arg("theDocument"),  py::arg("theRoots"),  py::arg("theFlags"),  py::arg("theDefStyle")=static_cast<const XCAFPrs_Style &>(XCAFPrs_Style ( )) )
    // custom constructors
    // methods
        .def("Init",
             (void (XCAFPrs_DocumentExplorer::*)( const opencascade::handle<TDocStd_Document> & ,  const TDF_Label & ,  const XCAFPrs_DocumentExplorerFlags ,  const XCAFPrs_Style &  ) ) static_cast<void (XCAFPrs_DocumentExplorer::*)( const opencascade::handle<TDocStd_Document> & ,  const TDF_Label & ,  const XCAFPrs_DocumentExplorerFlags ,  const XCAFPrs_Style &  ) >(&XCAFPrs_DocumentExplorer::Init),
             R"#(Initialize the iterator from a single root shape in the document.)#"  , py::arg("theDocument"),  py::arg("theRoot"),  py::arg("theFlags"),  py::arg("theDefStyle")=static_cast<const XCAFPrs_Style &>(XCAFPrs_Style ( ))
          )
        .def("Init",
             (void (XCAFPrs_DocumentExplorer::*)( const opencascade::handle<TDocStd_Document> & ,   const NCollection_Sequence<TDF_Label> & ,  const XCAFPrs_DocumentExplorerFlags ,  const XCAFPrs_Style &  ) ) static_cast<void (XCAFPrs_DocumentExplorer::*)( const opencascade::handle<TDocStd_Document> & ,   const NCollection_Sequence<TDF_Label> & ,  const XCAFPrs_DocumentExplorerFlags ,  const XCAFPrs_Style &  ) >(&XCAFPrs_DocumentExplorer::Init),
             R"#(Initialize the iterator from the list of root shapes in the document.)#"  , py::arg("theDocument"),  py::arg("theRoots"),  py::arg("theFlags"),  py::arg("theDefStyle")=static_cast<const XCAFPrs_Style &>(XCAFPrs_Style ( ))
          )
        .def("More",
             (Standard_Boolean (XCAFPrs_DocumentExplorer::*)() const) static_cast<Standard_Boolean (XCAFPrs_DocumentExplorer::*)() const>(&XCAFPrs_DocumentExplorer::More),
             R"#(Return TRUE if iterator points to the valid node.)#" 
          )
        .def("Current",
             (const XCAFPrs_DocumentNode & (XCAFPrs_DocumentExplorer::*)( Standard_Integer  ) const) static_cast<const XCAFPrs_DocumentNode & (XCAFPrs_DocumentExplorer::*)( Standard_Integer  ) const>(&XCAFPrs_DocumentExplorer::Current),
             R"#(Return current position within specified assembly depth.)#"  , py::arg("theDepth")
          )
        .def("CurrentDepth",
             (Standard_Integer (XCAFPrs_DocumentExplorer::*)() const) static_cast<Standard_Integer (XCAFPrs_DocumentExplorer::*)() const>(&XCAFPrs_DocumentExplorer::CurrentDepth),
             R"#(Return depth of the current node in hierarchy, starting from 0. Zero means Root label.)#" 
          )
        .def("Next",
             (void (XCAFPrs_DocumentExplorer::*)() ) static_cast<void (XCAFPrs_DocumentExplorer::*)() >(&XCAFPrs_DocumentExplorer::Next),
             R"#(Go to the next node.)#" 
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("DefineChildId_s",
                    (TCollection_AsciiString (*)( const TDF_Label & ,  const TCollection_AsciiString &  ) ) static_cast<TCollection_AsciiString (*)( const TDF_Label & ,  const TCollection_AsciiString &  ) >(&XCAFPrs_DocumentExplorer::DefineChildId),
                    R"#(Construct a unique string identifier for the given label. The identifier is a concatenation of label entries (TDF_Tool::Entry() with tailing '.') of hierarchy from parent to child joined via '/' and looking like this: This generation scheme also allows finding originating labels using TDF_Tool::Label(). The tailing dot simplifies parent equality check.)#"  , py::arg("theLabel"),  py::arg("theParentId")
          )
        .def_static("FindLabelFromPathId_s",
                    (TDF_Label (*)( const opencascade::handle<TDocStd_Document> & ,  const TCollection_AsciiString & ,  TopLoc_Location & ,  TopLoc_Location &  ) ) static_cast<TDF_Label (*)( const opencascade::handle<TDocStd_Document> & ,  const TCollection_AsciiString & ,  TopLoc_Location & ,  TopLoc_Location &  ) >(&XCAFPrs_DocumentExplorer::FindLabelFromPathId),
                    R"#(Find a shape entity based on a text identifier constructed from OCAF labels defining full path.)#"  , py::arg("theDocument"),  py::arg("theId"),  py::arg("theParentLocation"),  py::arg("theLocation")
          )
        .def_static("FindLabelFromPathId_s",
                    (TDF_Label (*)( const opencascade::handle<TDocStd_Document> & ,  const TCollection_AsciiString & ,  TopLoc_Location &  ) ) static_cast<TDF_Label (*)( const opencascade::handle<TDocStd_Document> & ,  const TCollection_AsciiString & ,  TopLoc_Location &  ) >(&XCAFPrs_DocumentExplorer::FindLabelFromPathId),
                    R"#(Find a shape entity based on a text identifier constructed from OCAF labels defining full path.)#"  , py::arg("theDocument"),  py::arg("theId"),  py::arg("theLocation")
          )
        .def_static("FindShapeFromPathId_s",
                    (TopoDS_Shape (*)( const opencascade::handle<TDocStd_Document> & ,  const TCollection_AsciiString &  ) ) static_cast<TopoDS_Shape (*)( const opencascade::handle<TDocStd_Document> & ,  const TCollection_AsciiString &  ) >(&XCAFPrs_DocumentExplorer::FindShapeFromPathId),
                    R"#(Find a shape entity based on a text identifier constructed from OCAF labels defining full path.)#"  , py::arg("theDocument"),  py::arg("theId")
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("Current",
             (const XCAFPrs_DocumentNode & (XCAFPrs_DocumentExplorer::*)() const) static_cast<const XCAFPrs_DocumentNode & (XCAFPrs_DocumentExplorer::*)() const>(&XCAFPrs_DocumentExplorer::Current),
             R"#(Return current position.)#"
             
         )
       .def("ChangeCurrent",
             (XCAFPrs_DocumentNode & (XCAFPrs_DocumentExplorer::*)() ) static_cast<XCAFPrs_DocumentNode & (XCAFPrs_DocumentExplorer::*)() >(&XCAFPrs_DocumentExplorer::ChangeCurrent),
             R"#(Return current position.)#"
             
             , py::return_value_policy::reference_internal
         )
       .def("ColorTool",
             (const opencascade::handle<XCAFDoc_ColorTool> & (XCAFPrs_DocumentExplorer::*)() const) static_cast<const opencascade::handle<XCAFDoc_ColorTool> & (XCAFPrs_DocumentExplorer::*)() const>(&XCAFPrs_DocumentExplorer::ColorTool),
             R"#(Return color tool.)#"
             
         )
       .def("VisMaterialTool",
             (const opencascade::handle<XCAFDoc_VisMaterialTool> & (XCAFPrs_DocumentExplorer::*)() const) static_cast<const opencascade::handle<XCAFDoc_VisMaterialTool> & (XCAFPrs_DocumentExplorer::*)() const>(&XCAFPrs_DocumentExplorer::VisMaterialTool),
             R"#(Return material tool.)#"
             
         )
;

    // Class XCAFPrs_DocumentIdIterator from ./opencascade/XCAFPrs_DocumentIdIterator.hxx
    klass = m.attr("XCAFPrs_DocumentIdIterator");


    // nested enums

    static_cast<py::class_<XCAFPrs_DocumentIdIterator , shared_ptr<XCAFPrs_DocumentIdIterator>  >>(klass)
    // constructors
        .def(py::init< const TCollection_AsciiString & >()  , py::arg("thePath") )
    // custom constructors
    // methods
        .def("More",
             (bool (XCAFPrs_DocumentIdIterator::*)() const) static_cast<bool (XCAFPrs_DocumentIdIterator::*)() const>(&XCAFPrs_DocumentIdIterator::More),
             R"#(Return TRUE if iterator points to a value.)#" 
          )
        .def("Next",
             (void (XCAFPrs_DocumentIdIterator::*)() ) static_cast<void (XCAFPrs_DocumentIdIterator::*)() >(&XCAFPrs_DocumentIdIterator::Next),
             R"#(Find the next value.)#" 
          )
        .def("Next",
             (void (XCAFPrs_DocumentIdIterator::*)() ) static_cast<void (XCAFPrs_DocumentIdIterator::*)() >(&XCAFPrs_DocumentIdIterator::Next),
             R"#(Find the next value.)#" 
          )
    // methods using call by reference i.s.o. return
    // static methods
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("Value",
             (const TCollection_AsciiString & (XCAFPrs_DocumentIdIterator::*)() const) static_cast<const TCollection_AsciiString & (XCAFPrs_DocumentIdIterator::*)() const>(&XCAFPrs_DocumentIdIterator::Value),
             R"#(Return current value.)#"
             
         )
;

    // Class XCAFPrs_DocumentNode from ./opencascade/XCAFPrs_DocumentNode.hxx
    klass = m.attr("XCAFPrs_DocumentNode");


    // nested enums

    static_cast<py::class_<XCAFPrs_DocumentNode , shared_ptr<XCAFPrs_DocumentNode>  >>(klass)
    // constructors
        .def(py::init<  >()  )
    // custom constructors
    // methods
    // methods using call by reference i.s.o. return
    // static methods
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
        .def_readwrite("Id", &XCAFPrs_DocumentNode::Id)
        .def_readwrite("Label", &XCAFPrs_DocumentNode::Label)
        .def_readwrite("RefLabel", &XCAFPrs_DocumentNode::RefLabel)
        .def_readwrite("Style", &XCAFPrs_DocumentNode::Style)
        .def_readwrite("Location", &XCAFPrs_DocumentNode::Location)
        .def_readwrite("LocalTrsf", &XCAFPrs_DocumentNode::LocalTrsf)
        .def_readwrite("ChildIter", &XCAFPrs_DocumentNode::ChildIter)
        .def_readwrite("IsAssembly", &XCAFPrs_DocumentNode::IsAssembly)
    // methods returning by ref wrapped as properties
;

    // Class XCAFPrs_Driver from ./opencascade/XCAFPrs_Driver.hxx
    klass = m.attr("XCAFPrs_Driver");

    // default constructor
    register_default_constructor<XCAFPrs_Driver ,opencascade::handle<XCAFPrs_Driver>>(m,"XCAFPrs_Driver");

    // nested enums

    static_cast<py::class_<XCAFPrs_Driver ,opencascade::handle<XCAFPrs_Driver>  , TPrsStd_Driver >>(klass)
    // constructors
    // custom constructors
    // methods
        .def("Update",
             (Standard_Boolean (XCAFPrs_Driver::*)( const TDF_Label & ,  opencascade::handle<AIS_InteractiveObject> &  ) ) static_cast<Standard_Boolean (XCAFPrs_Driver::*)( const TDF_Label & ,  opencascade::handle<AIS_InteractiveObject> &  ) >(&XCAFPrs_Driver::Update),
             R"#(None)#"  , py::arg("L"),  py::arg("ais")
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("GetID_s",
                    (const Standard_GUID & (*)() ) static_cast<const Standard_GUID & (*)() >(&XCAFPrs_Driver::GetID),
                    R"#(returns GUID of the driver)#" 
          )
        .def_static("get_type_name_s",
                    (const char * (*)() ) static_cast<const char * (*)() >(&XCAFPrs_Driver::get_type_name),
                    R"#(None)#" 
          )
        .def_static("get_type_descriptor_s",
                    (const opencascade::handle<Standard_Type> & (*)() ) static_cast<const opencascade::handle<Standard_Type> & (*)() >(&XCAFPrs_Driver::get_type_descriptor),
                    R"#(None)#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("DynamicType",
             (const opencascade::handle<Standard_Type> & (XCAFPrs_Driver::*)() const) static_cast<const opencascade::handle<Standard_Type> & (XCAFPrs_Driver::*)() const>(&XCAFPrs_Driver::DynamicType),
             R"#(None)#"
             
         )
;

    // Class XCAFPrs_Style from ./opencascade/XCAFPrs_Style.hxx
    klass = m.attr("XCAFPrs_Style");


    // nested enums

    static_cast<py::class_<XCAFPrs_Style , shared_ptr<XCAFPrs_Style>  >>(klass)
    // constructors
        .def(py::init<  >()  )
    // custom constructors
    // methods
        .def("IsEmpty",
             (Standard_Boolean (XCAFPrs_Style::*)() const) static_cast<Standard_Boolean (XCAFPrs_Style::*)() const>(&XCAFPrs_Style::IsEmpty),
             R"#(Return TRUE if style is empty - does not override any properties.)#" 
          )
        .def("SetMaterial",
             (void (XCAFPrs_Style::*)( const opencascade::handle<XCAFDoc_VisMaterial> &  ) ) static_cast<void (XCAFPrs_Style::*)( const opencascade::handle<XCAFDoc_VisMaterial> &  ) >(&XCAFPrs_Style::SetMaterial),
             R"#(Set material.)#"  , py::arg("theMaterial")
          )
        .def("IsSetColorSurf",
             (Standard_Boolean (XCAFPrs_Style::*)() const) static_cast<Standard_Boolean (XCAFPrs_Style::*)() const>(&XCAFPrs_Style::IsSetColorSurf),
             R"#(Return TRUE if surface color has been defined.)#" 
          )
        .def("SetColorSurf",
             (void (XCAFPrs_Style::*)( const Quantity_Color &  ) ) static_cast<void (XCAFPrs_Style::*)( const Quantity_Color &  ) >(&XCAFPrs_Style::SetColorSurf),
             R"#(Set surface color.)#"  , py::arg("theColor")
          )
        .def("SetColorSurf",
             (void (XCAFPrs_Style::*)( const Quantity_ColorRGBA &  ) ) static_cast<void (XCAFPrs_Style::*)( const Quantity_ColorRGBA &  ) >(&XCAFPrs_Style::SetColorSurf),
             R"#(Set surface color.)#"  , py::arg("theColor")
          )
        .def("UnSetColorSurf",
             (void (XCAFPrs_Style::*)() ) static_cast<void (XCAFPrs_Style::*)() >(&XCAFPrs_Style::UnSetColorSurf),
             R"#(Manage surface color setting)#" 
          )
        .def("IsSetColorCurv",
             (Standard_Boolean (XCAFPrs_Style::*)() const) static_cast<Standard_Boolean (XCAFPrs_Style::*)() const>(&XCAFPrs_Style::IsSetColorCurv),
             R"#(Return TRUE if curve color has been defined.)#" 
          )
        .def("SetColorCurv",
             (void (XCAFPrs_Style::*)( const Quantity_Color &  ) ) static_cast<void (XCAFPrs_Style::*)( const Quantity_Color &  ) >(&XCAFPrs_Style::SetColorCurv),
             R"#(Set curve color.)#"  , py::arg("col")
          )
        .def("UnSetColorCurv",
             (void (XCAFPrs_Style::*)() ) static_cast<void (XCAFPrs_Style::*)() >(&XCAFPrs_Style::UnSetColorCurv),
             R"#(Manage curve color setting)#" 
          )
        .def("SetVisibility",
             (void (XCAFPrs_Style::*)( const Standard_Boolean  ) ) static_cast<void (XCAFPrs_Style::*)( const Standard_Boolean  ) >(&XCAFPrs_Style::SetVisibility),
             R"#(Assign visibility.)#"  , py::arg("theVisibility")
          )
        .def("IsVisible",
             (Standard_Boolean (XCAFPrs_Style::*)() const) static_cast<Standard_Boolean (XCAFPrs_Style::*)() const>(&XCAFPrs_Style::IsVisible),
             R"#(Manage visibility.)#" 
          )
        .def("IsEqual",
             (Standard_Boolean (XCAFPrs_Style::*)( const XCAFPrs_Style &  ) const) static_cast<Standard_Boolean (XCAFPrs_Style::*)( const XCAFPrs_Style &  ) const>(&XCAFPrs_Style::IsEqual),
             R"#(Returns True if styles are the same Methods for using Style as key in maps)#"  , py::arg("theOther")
          )
        .def("DumpJson",
             (void (XCAFPrs_Style::*)( std::ostream & ,  Standard_Integer  ) const) static_cast<void (XCAFPrs_Style::*)( std::ostream & ,  Standard_Integer  ) const>(&XCAFPrs_Style::DumpJson),
             R"#(Dumps the content of me into the stream)#"  , py::arg("theOStream"),  py::arg("theDepth")=static_cast<Standard_Integer>(- 1)
          )
    // methods using call by reference i.s.o. return
    // static methods
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("Material",
             (const opencascade::handle<XCAFDoc_VisMaterial> & (XCAFPrs_Style::*)() const) static_cast<const opencascade::handle<XCAFDoc_VisMaterial> & (XCAFPrs_Style::*)() const>(&XCAFPrs_Style::Material),
             R"#(Return material.)#"
             
         )
       .def("GetColorSurf",
             (const Quantity_Color & (XCAFPrs_Style::*)() const) static_cast<const Quantity_Color & (XCAFPrs_Style::*)() const>(&XCAFPrs_Style::GetColorSurf),
             R"#(Return surface color.)#"
             
         )
       .def("GetColorSurfRGBA",
             (const Quantity_ColorRGBA & (XCAFPrs_Style::*)() const) static_cast<const Quantity_ColorRGBA & (XCAFPrs_Style::*)() const>(&XCAFPrs_Style::GetColorSurfRGBA),
             R"#(Return surface color.)#"
             
         )
       .def("GetColorCurv",
             (const Quantity_Color & (XCAFPrs_Style::*)() const) static_cast<const Quantity_Color & (XCAFPrs_Style::*)() const>(&XCAFPrs_Style::GetColorCurv),
             R"#(Return curve color.)#"
             
         )
       .def("BaseColorTexture",
             (const opencascade::handle<Image_Texture> & (XCAFPrs_Style::*)() const) static_cast<const opencascade::handle<Image_Texture> & (XCAFPrs_Style::*)() const>(&XCAFPrs_Style::BaseColorTexture),
             R"#(Return base color texture.)#"
             
         )
;

    // Class XCAFPrs_Texture from ./opencascade/XCAFPrs_Texture.hxx
    klass = m.attr("XCAFPrs_Texture");


    // nested enums

    static_cast<py::class_<XCAFPrs_Texture ,opencascade::handle<XCAFPrs_Texture>  , Graphic3d_Texture2D >>(klass)
    // constructors
        .def(py::init< const opencascade::handle<Image_Texture> &,const Graphic3d_TextureUnit >()  , py::arg("theImageSource"),  py::arg("theUnit") )
    // custom constructors
    // methods
        .def("GetCompressedImage",
             (opencascade::handle<Image_CompressedPixMap> (XCAFPrs_Texture::*)( const opencascade::handle<Image_SupportedFormats> &  ) ) static_cast<opencascade::handle<Image_CompressedPixMap> (XCAFPrs_Texture::*)( const opencascade::handle<Image_SupportedFormats> &  ) >(&XCAFPrs_Texture::GetCompressedImage),
             R"#(Image reader.)#"  , py::arg("theSupported")
          )
        .def("GetImage",
             (opencascade::handle<Image_PixMap> (XCAFPrs_Texture::*)( const opencascade::handle<Image_SupportedFormats> &  ) ) static_cast<opencascade::handle<Image_PixMap> (XCAFPrs_Texture::*)( const opencascade::handle<Image_SupportedFormats> &  ) >(&XCAFPrs_Texture::GetImage),
             R"#(Image reader.)#"  , py::arg("theSupported")
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("get_type_name_s",
                    (const char * (*)() ) static_cast<const char * (*)() >(&XCAFPrs_Texture::get_type_name),
                    R"#(None)#" 
          )
        .def_static("get_type_descriptor_s",
                    (const opencascade::handle<Standard_Type> & (*)() ) static_cast<const opencascade::handle<Standard_Type> & (*)() >(&XCAFPrs_Texture::get_type_descriptor),
                    R"#(None)#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("DynamicType",
             (const opencascade::handle<Standard_Type> & (XCAFPrs_Texture::*)() const) static_cast<const opencascade::handle<Standard_Type> & (XCAFPrs_Texture::*)() const>(&XCAFPrs_Texture::DynamicType),
             R"#(None)#"
             
         )
       .def("GetImageSource",
             (const opencascade::handle<Image_Texture> & (XCAFPrs_Texture::*)() const) static_cast<const opencascade::handle<Image_Texture> & (XCAFPrs_Texture::*)() const>(&XCAFPrs_Texture::GetImageSource),
             R"#(Return image source.)#"
             
         )
;

// functions
// ./opencascade/XCAFPrs.hxx
// ./opencascade/XCAFPrs_AISObject.hxx
// ./opencascade/XCAFPrs_DataMapIteratorOfDataMapOfStyleShape.hxx
// ./opencascade/XCAFPrs_DataMapIteratorOfDataMapOfStyleTransient.hxx
// ./opencascade/XCAFPrs_DataMapIteratorOfIndexedDataMapOfShapeStyle.hxx
// ./opencascade/XCAFPrs_DataMapOfStyleShape.hxx
// ./opencascade/XCAFPrs_DataMapOfStyleTransient.hxx
// ./opencascade/XCAFPrs_DocumentExplorer.hxx
// ./opencascade/XCAFPrs_DocumentIdIterator.hxx
// ./opencascade/XCAFPrs_DocumentNode.hxx
// ./opencascade/XCAFPrs_Driver.hxx
// ./opencascade/XCAFPrs_IndexedDataMapOfShapeStyle.hxx
// ./opencascade/XCAFPrs_Style.hxx
// ./opencascade/XCAFPrs_Texture.hxx

// Additional functions

// operators

// register typdefs
    register_template_NCollection_DataMap<XCAFPrs_Style, TopoDS_Shape>(m,"XCAFPrs_DataMapOfStyleShape");
    register_template_NCollection_IndexedDataMap<TopoDS_Shape, XCAFPrs_Style, TopTools_ShapeMapHasher>(m,"XCAFPrs_IndexedDataMapOfShapeStyle");


// exceptions

// user-defined post-inclusion per module in the body

};

// user-defined post-inclusion per module

// user-defined post
