% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/backend-spark-sql.R
\name{backend-spark-sql}
\alias{simulate_spark_sql}
\title{Backend: Databricks Spark SQL}
\usage{
simulate_spark_sql()
}
\description{
See \code{vignette("translation-function")} and \code{vignette("translation-verb")} for
details of overall translation technology. Key differences for this backend
are better translation of statistical aggregate functions
(e.g. \code{var()}, \code{median()}) and use of temporary views instead of temporary
tables when copying data.

Use \code{simulate_spark_sql()} with \code{lazy_frame()} to see simulated SQL without
converting to live access database.
}
\examples{
library(dplyr, warn.conflicts = FALSE)

lf <- lazy_frame(a = TRUE, b = 1, d = 2, c = "z", con = simulate_spark_sql())

lf \%>\% summarise(x = median(d, na.rm = TRUE))
lf \%>\% summarise(x = var(c, na.rm = TRUE), .by = d)

lf \%>\% mutate(x = first(c))
lf \%>\% mutate(x = first(c), .by = d)
}
