% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/agg_dev.R
\name{agg_capture}
\alias{agg_capture}
\title{Draw to a buffer that can be accessed directly}
\usage{
agg_capture(
  width = 480,
  height = 480,
  units = "px",
  pointsize = 12,
  background = "white",
  res = 72,
  scaling = 1,
  snap_rect = TRUE,
  bg
)
}
\arguments{
\item{width, height}{The dimensions of the device}

\item{units}{The unit \code{width} and \code{height} is measured in, in either pixels
(\code{'px'}), inches (\code{'in'}), millimeters (\code{'mm'}), or centimeter (\code{'cm'}).}

\item{pointsize}{The default pointsize of the device in pt. This will in
general not have any effect on grid graphics (including ggplot2) as text
size is always set explicitly there.}

\item{background}{The background colour of the device}

\item{res}{The resolution of the device. This setting will govern how device
dimensions given in inches, centimeters, or millimeters will be converted
to pixels. Further, it will be used to scale text sizes and linewidths}

\item{scaling}{A scaling factor to apply to the rendered line width and text
size. Useful for getting the right dimensions at the resolution that you
need. If e.g. you need to render a plot at 4000x3000 pixels for it to fit
into a layout, but you find that the result appears to small, you can
increase the \code{scaling} argument to make everything appear bigger at the
same resolution.}

\item{snap_rect}{Should axis-aligned rectangles drawn with only fill snap to
the pixel grid. This will prevent anti-aliasing artifacts when two
rectangles are touching at their border.}

\item{bg}{Same as \code{background} for compatibility with old graphic device APIs}
}
\value{
A function that when called returns the current state of the buffer.
The return value of the function depends on the \code{native} argument. If \code{FALSE}
(default) the return value is a \code{matrix} of colour values and if \code{TRUE} the
return value is a \code{nativeRaster} object.
}
\description{
Usually the point of using a graphic device is to create a file or show the
graphic on the screen. A few times we need the image data for further
processing in R, and instead of writing it to a file and then reading it back
into R the \code{agg_capture()} device lets you get the image data directly from
the buffer. In contrast to the other devices this device returns a function,
that when called will return the current state of the buffer.
}
\examples{
cap <- agg_capture()
plot(1:10, 1:10)

# Get the plot as a matrix
raster <- cap()

# Get the plot as a nativeRaster
raster_n <- cap(native = TRUE)

dev.off()

# Look at the output
plot(as.raster(raster))

}
