/// lfs error type
#[derive(Debug, snafu::Snafu)]
#[snafu(visibility(pub(crate)))]
pub enum Error {
    #[snafu(display("Couldn't execute {exe}"))]
    CantExecute { source: std::io::Error, exe: String },

    #[snafu(display("Could not read metadata of file {path:?}"))]
    CantReadFileMetadata {
        source: std::io::Error,
        path: std::path::PathBuf,
    },

    #[snafu(display("Could not read file {path:?}"))]
    CantReadFile {
        source: std::io::Error,
        path: std::path::PathBuf,
    },

    #[snafu(display("Could not read dir {path:?}"))]
    CantReadDir {
        source: std::io::Error,
        path: std::path::PathBuf,
    },

    #[snafu(display("Could not parse mountinfo"))]
    #[cfg(target_os = "linux")]
    ParseMountInfo {
        source: crate::linux::ParseMountInfoError,
    },

    #[snafu(display("Unexpected format"))]
    UnexpectedFormat,

    #[snafu(display("Error parsing device id"))]
    ParseDeviceId,

    #[snafu(display("Failed to call service {service:?}"))]
    ServiceCallFailed { service: &'static str },

    #[snafu(display("Failed to read {key:?}"))]
    MissingValue { key: &'static str },

    #[snafu(display("Device layer not found"))]
    DeviceLayerNotFound,

    #[cfg(windows)]
    #[snafu(display("Windows API call failed: {api}"))]
    WindowsApiError {
        source: windows::core::Error,
        api: String,
    },
}
