/*
 * YICS: Connect a FICS interface to the Yahoo! Chess server.
 * Copyright (C) 2004  Chris Howie
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

#include <stdio.h>
#include <string.h>
#include <time.h>
#include <stdlib.h>
#include "globals.h"
#include "types.h"
#include "util.h"
#include "console.h"

long int session = 0;
char handle[256] = "";
bool login_complete = false;
FILE *netlog = NULL;
Player *pme = NULL, *lasttell = NULL, *lastopp = NULL;
Player *players[PLAYER_MAX];
Option *clientOptions = NULL;
Table *tables[TABLE_MAX + 1];	/* +1 because tables[0] isn't used */
int primary = -1;
Invite *invitations = NULL;
Invite *lastinvite = NULL;
char s_buffer[4096];

time_t lastcommand;

Player *findPlayer(const char *name) {
	int i = 0;
	char *uname = malloc(strlen(name) + 1);

	if (uname == NULL)
		return NULL;

	strcpy(uname, name);
	lowercase(uname);

	while (i < PLAYER_MAX) {
		if (players[i] && !strcmp(players[i]->lhandle, uname)) {
			free(uname);
			return players[i];
		}
		i++;
	}

	free(uname);
	return NULL;
}

Player *completeHandle(String *name) {
	int i;
	bool youlose = false;
	char *ambig[PLAYER_MAX];
	char **ap = ambig;
	int acount = 0;
	Player *match = NULL;

	/* Looking for an exact match? */
	if (name->string[name->length - 1] == '!') {
		name->string[name->length - 1] = '\0';

		match = findPlayer(name->string);
		if (match == NULL) {
			iprintf("There is no player matching the name %s.\n",
				name->string);
			prompt();
		}

		name->string[name->length - 1] = '!';
		return match;
	}

	lowercase(name->string);
	for (i = 0; i < PLAYER_MAX; i++) {
		if (players[i] == NULL)
			continue;
		if (!strcmp(name->string, players[i]->lhandle))
			return players[i];
		if ((name->length <= (int)strlen(players[i]->lhandle)) &&
		!memcmp(players[i]->lhandle, name->string, name->length)) {
			if (match == NULL) {
				match = players[i];
			} else {
				if (!youlose) {
					youlose = true;
					*(ap++) = match->handle;
					acount++;
				}

				*(ap++) = players[i]->handle;
				acount++;
			}
		}
	}

	if (youlose) {
		*ap = NULL;
		qsort(ambig, acount, sizeof(char *), s_strcmp);
		iprintf("-- Matches: %d player(s) --\n", acount);
		columns(ambig);
		prompt();
		return NULL;
	}

	if (match == NULL) {
		iprintf("There is no player matching the name %s.\n", name->string);
		prompt();
		return NULL;
	}

	return match;
}

Table *findTable(String *text, String *resolved) {
	int number;
	Player *p;
	Table *obs[TABLE_MAX];
	Table **op;
	char tmp[64];

	if (isnumeric(text->string)) {
		number = atoi(text->string);

		if (number < 0) {
			iprintf("%d is not a valid game number.\n", number);
			prompt();
			return NULL;
		}

		if ((number > TABLE_MAX) || (tables[number] == NULL)) {
			iprint("There is no such game.\n");
			prompt();
			return NULL;
		}

		if (resolved != NULL) {
			sprintf(tmp, "game %d", number);
			StringSet(resolved, tmp, -1);
		}

		return tables[number];
	} else if ((p = completeHandle(text)) != NULL) {
		observing(obs, p);

		for (op = obs; *op != NULL; op++)
			if (((*op)->players[0] == p) || ((*op)->players[1] == p)) {
				if (resolved != NULL)
					StringSet(resolved, p->handle, -1);

				return *op;
			}

		iprintf("%s is not playing a game.\n", p->handle);
		prompt();
	}

	return NULL;
}

String *realHandle(String *name) {
	Player *p = findPlayer(name->string);

	if (p != NULL)
		StringSet(name, p->handle, -1);

	return name;
}

void observing(Table **out, const Player *who) {
	int i, j;
	Table *table;

	for (i = 0; i < TABLE_MAX; i++) {
		if (tables[i] == NULL)
			continue;

		table = tables[i];
		for (j = 0; j < PLAYER_MAX; j++) {
			if (table->observers[j] == who) {
				*(out++) = table;
				break;
			}
		}
	}

	*out = NULL;
}

void addInvite(Player *who, uchar number, InviteType type) {
	Invite *new = malloc(sizeof(Invite));

	if (new == NULL)
		return;

	new->who = who;
	new->number = number;
	new->type = type;
	new->next = NULL;
	new->last = lastinvite;

	if (lastinvite == NULL)
		invitations = new;
	else
		lastinvite->next = new;

	lastinvite = new;
}

bool delInvite(Player *who, uchar number) {
	Invite *current = invitations;
	Invite *next, *last;
	bool gotone = false;

	if ((who == NULL) && (number == 0))
		/* Don't destroy them all... */
		return false;

	while (current != NULL) {
		next = current->next;
		if (((who == NULL) || (who    == current->who   )) &&
		    ((number == 0) || (number == current->number))) {
			last = current->last;

			if (last == NULL)
				invitations = next;
			else
				last->next = next;

			if (next == NULL)
				lastinvite = last;
			else
				next->last = last;

			free(current);
			gotone = true;
		}
		current = next;
	}

	return gotone;
}

void destroyInvite() {
	Invite *current = invitations, *next;

	while (current != NULL) {
		next = current->next;
		free(current);
		current = next;
	}

	invitations = lastinvite = NULL;
}
